<?php
/**
 * Simple Restaurant Menu Display
 *
 * @since             1.0.0
 * @package           Simple_Restaurant_Menu_Display
 *
 * @wordpress-plugin
 * Plugin Name:       Simple Restaurant Menu Display
 * Description:       A lightweight plugin to manage and display restaurant menus with multiple quantity-price options and special tags.
 * Version:           1.0.0
 * Requires at least: 5.0
 * Author:            Vik Cheema
 * Author URI:        https://vikcheema.com
 * License: 					GPL-2.0-or-later
 * License URI: 			https://www.gnu.org/licenses/gpl-2.0.html
 * Text Domain:       simple-restaurant-menu-display
 * Domain Path:       /languages
 */

 defined('ABSPATH') || exit;

define('SIMPREMED_VERSION', '1.0.0');
define('SIMPREMED_PLUGIN_URL', plugin_dir_url(__FILE__));
define('SIMPREMED_PLUGIN_PATH', plugin_dir_path(__FILE__));


// Load helper functions and classes.
require_once SIMPREMED_PLUGIN_PATH . 'includes/simpremed-functions.php';
require_once SIMPREMED_PLUGIN_PATH . 'includes/class-simpremed-menu-loader.php';
require_once SIMPREMED_PLUGIN_PATH . 'includes/class-simpremed-shortcodes.php';
require_once SIMPREMED_PLUGIN_PATH . 'includes/simpremed-meta-boxes.php';
// Register dynamic block render callback
require_once SIMPREMED_PLUGIN_PATH . 'includes/simpremed-blocks.php';

/**
 * Initialize the shortcodes by instantiating the handler class.
 *
 * @return void
 */
function simpremed_init_shortcodes() {
	new Simpremed_Shortcodes();
}
add_action('init', 'simpremed_init_shortcodes');

/**
 * Allow developers to override the default template path via filter.
 *
 * @var string $template_path Path used to locate override templates in the theme.
 */
$template_path = apply_filters('simpremed_template_path', 'simple-restaurant-menu-display/');


/**
 * Enqueue plugin and theme override assets for both frontend and admin.
 *
 * @return void
 */
function simpremed_enqueue_assets() {
	// Frontend and Admin CSS
	wp_enqueue_style(
    'simpremed-style',
    SIMPREMED_PLUGIN_URL . 'assets/css/simpremed-style.css',
    array(),
    SIMPREMED_VERSION,
    'all'
	);

	// Theme override CSS (optional)
	if (file_exists(get_stylesheet_directory() . '/simpremed-style.css')) {
	
		wp_enqueue_style(
			'simpremed-style-override',
			get_stylesheet_directory_uri() . '/simpremed-style.css',
			array(),
			SIMPREMED_VERSION,
			'all'
		);

	}

	// Admin-specific JS
	if (is_admin()) {
		global $post_type;
		if ($post_type === 'simpremed_menu_item') {
			wp_set_script_translations( 'simpremed-block', 'simple-restaurant-menu-display' );
			wp_set_script_translations( 'simpremed-block', 'simple-restaurant-menu-display' );
			wp_enqueue_script('simpremed-admin-repeater', SIMPREMED_PLUGIN_URL . 'assets/js/simpremed-admin-repeater.js', ['jquery'], SIMPREMED_VERSION, true);
		}
	} else {
		// Frontend JS
		wp_enqueue_script('simpremed-scripts', SIMPREMED_PLUGIN_URL . 'assets/js/simpremed-scripts.js', ['jquery'], SIMPREMED_VERSION, true);
		wp_localize_script('simpremed-scripts', 'simpremed_ajax', [
			'ajax_url' => admin_url('admin-ajax.php')
		]);
	}
}
add_action('admin_enqueue_scripts', 'simpremed_enqueue_assets');
add_action('wp_enqueue_scripts', 'simpremed_enqueue_assets');

/**
 * Register a Gutenberg block that outputs the restaurant menu shortcode.
 *
 * @return void
 */
function simpremed_enqueue_block_editor_assets() {
	wp_enqueue_script(
		'simpremed-block',
		plugins_url( 'block/simpremed-block.js', __FILE__ ),
		[ 'wp-blocks', 'wp-element', 'wp-editor', 'wp-components', 'wp-i18n' ],
		'1.0.0',
		true
	);

	wp_set_script_translations( 'simpremed-block', 'simple-restaurant-menu-display' );
}
add_action( 'enqueue_block_editor_assets', 'simpremed_enqueue_block_editor_assets' );