<?php

if ( ! defined( 'ABSPATH' ) ) exit;

/**
 * Register a meta box for marking a menu item as "Special"
 *
 * @return void
 */
function simpremed_add_special_meta_box() {
    add_meta_box(
        'simpremed_special_meta',
        __('Special Item', 'simple-restaurant-menu-display'),
        'simpremed_render_special_meta_box',
        'simpremed_menu_item',
        'side',
        'default'
    );
}
add_action('add_meta_boxes', 'simpremed_add_special_meta_box');

/**
 * Render the "Special Item" checkbox in the meta box
 *
 * @param WP_Post $post The current post object.
 *
 * @return void
 */
function simpremed_render_special_meta_box($post) {
    wp_nonce_field('simpremed_save_special_meta', 'simpremed_special_nonce');
    $value = get_post_meta($post->ID, 'simpremed_is_special', true);
    ?>
    <label>
        <input type="checkbox" name="simpremed_is_special" value="1" <?php checked($value, '1'); ?> />
        <?php esc_html_e('Mark this item as special', 'simple-restaurant-menu-display'); ?>
    </label>
    <?php
}

/**
 * Save the "Special Item" meta value when the post is saved
 *
 * @param int $post_id The ID of the current post being saved.
 *
 * @return void
 */
/**
 * Save the 'Special' checkbox meta value for menu items.
 *
 * @param int $post_id The ID of the post being saved.
 */
function simpremed_save_special_meta_box( $post_id ) {
	// Verify the nonce securely.
	$nonce = isset( $_POST['simpremed_special_nonce'] ) ? sanitize_text_field( wp_unslash( $_POST['simpremed_special_nonce'] ) ) : '';
	if ( ! $nonce || ! wp_verify_nonce( $nonce, 'simpremed_save_special_meta' ) ) {
		return;
	}

	// Check for autosave.
	if ( defined( 'DOING_AUTOSAVE' ) && DOING_AUTOSAVE ) {
		return;
	}

	// Check user permissions.
	if ( isset( $_POST['post_type'] ) && 'simpremed_menu_item' === $_POST['post_type'] && ! current_user_can( 'edit_post', $post_id ) ) {
		return;
	}

	// Save the meta value.
	$is_special = isset( $_POST['simpremed_is_special'] ) ? '1' : '';
	update_post_meta( $post_id, 'simpremed_is_special', $is_special );
}
add_action( 'save_post', 'simpremed_save_special_meta_box' );
