<?php

if ( ! defined( 'ABSPATH' ) ) exit;

/**
 * Registers the Gutenberg block for displaying the Simple Restaurant Menu via shortcode.
 *
 * This function is hooked into 'init' and registers the block with a render callback.
 *
 * @since 1.0.0
 */
function simpremed_register_menu_block() {
    register_block_type( 'simpremed/menu-shortcode', [
        'render_callback' => 'simpremed_render_menu_block',
        'attributes'      => [
            'section' => [
                'type'    => 'string',
                'default' => '',
            ],
            'special' => [
                'type'    => 'boolean',
                'default' => false,
            ],
        ],
    ] );
}
add_action( 'init', 'simpremed_register_menu_block' );

/**
 * Render callback for the Simple Restaurant Menu block.
 *
 * This function builds a shortcode string from block attributes and executes it.
 *
 * @since 1.0.0
 *
 * @param array $attributes {
 *     Attributes passed from the block editor.
 *
 *     @type string  $section Section slug to filter menu items.
 *     @type boolean $special Whether to show only special items.
 * }
 *
 * @return string HTML content rendered by the shortcode.
 */
function simpremed_render_menu_block( $attributes ) {
    $section = isset( $attributes['section'] ) ? $attributes['section'] : '';
    $special = ! empty( $attributes['special'] ) ? 'yes' : '';

    // Generate and execute the shortcode with appropriate attributes.
    return do_shortcode( sprintf(
        '[simple_restaurant_menu_display%s%s]',
        $section ? ' section="' . esc_attr( $section ) . '"' : '',
        $special ? ' special="yes"' : ''
    ) );
}
