/**
 * Handles dynamic row addition and removal for the SRMD Quantity & Prices repeater.
 *
 * @since 1.0.0
 */
jQuery(document).ready(function($) {
    /**
     * Adds a new row to the repeater table when the "Add Row" button is clicked.
     *
     * @param {Event} e - The click event.
     */
    $('#simpremed-add-row').on('click', function(e) {
        e.preventDefault();

        // HTML for a new row with empty inputs for label and price
        const row = '<tr>' +
            '<td><input type="text" name="simpremed_label[]" /></td>' +
            '<td><input type="text" name="simpremed_price[]" /></td>' +
            '<td><button class="button simpremed-remove-row">X</button></td>' +
        '</tr>';

        $('.simpremed-repeater tbody').append(row);
    });

    /**
     * Removes a repeater row when the "X" button is clicked.
     *
     * @param {Event} e - The click event.
     */
    $(document).on('click', '.simpremed-remove-row', function(e) {
        e.preventDefault();

        // Remove the closest table row
        $(this).closest('tr').remove();
    });
});
