# Simple Restaurant Menu Display

**Contributors:** vikcheema
**Donate link:** https://paypal.me/SukhwantCheema
**Tags:** restaurant, menu, custom post type, ajax, repeater, shortcode  
**Requires at least:** 5.0  
**Tested up to:** 6.8.1  
**Stable tag:** 1.0.0  
**License:** GPLv2 or later  
**License URI:** [https://www.gnu.org/licenses/gpl-2.0.html](https://www.gnu.org/licenses/gpl-2.0.html)

A lightweight and flexible restaurant menu plugin with custom post types, repeater fields, and Gutenberg block support.

---

## Description

Simple Restaurant Menu Display allows you to:

- Create and categorize menu items using a custom post type and taxonomy
- Define multiple quantity/price pairs for items (like size/portion/volume)
- Mark items as "Special" with a custom field badge
- Override styles using your theme
- Insert menus easily via a Gutenberg block or shortcode

---

## Installation

1. Upload the plugin files to the `/wp-content/plugins/` directory.
2. Activate the plugin through the **Plugins** screen in WordPress.
3. Navigate to **Menu Items** to add your restaurant's dishes.
4. Use the `[simple_restaurant_menu_display]` shortcode to embed menus in pages/posts.

---

## Usage

- Add menu items under **Menu Items > Add New** in the admin.
- Assign items to a **Menu Section** (taxonomy).
- Optionally mark as **Special** or add pricing quantities.
- `[simple_restaurant_menu_display]` — shows full menu grouped by section.
- `[simple_restaurant_menu_display section="breakfast"]` — filters items to the "breakfast" section.
- `[simple_restaurant_menu_display special="yes"]` — shows only special items.
- `[simple_restaurant_menu_display section="lunch" special="yes"]` — shows special lunch items.
- Insert the **Menu Block** via the Gutenberg editor.

---

## Template Overrides

You can override the HTML templates used to display menu items.

### Template Files You Can Override

| Plugin File                  | Theme Override Location                                      |
|-----------------------------|--------------------------------------------------------------|
| `templates/simpremed-menu-item.php`   | `your-theme/simple-restaurant-menu-display/simpremed-menu-item.php`   |
| `templates/simpremed-menu-loop.php`   | `your-theme/simple-restaurant-menu-display/simpremed-menu-loop.php`   |

### How to Override

1. Create this directory in your theme:  
   `/wp-content/themes/your-theme/simple-restaurant-menu-display/`

2. Copy the plugin template file(s) to your theme directory.

3. Edit the templates in your theme as needed.

> ✅ If a template file exists in your theme, it will be used instead of the plugin default.

---

## Filters

- `simpremed_currency_symbol` — Change the currency symbol.
- `simpremed_template_part` — Customize the logic for loading template parts.

---

## Frequently Asked Questions

### Can I add multiple prices for a single item?

Yes! Use the quantity/price repeater on the edit screen.

### Can I style the menu to match my theme?

Yes, you can override `simpremed-style.css` in your theme folder.

### Is it Gutenberg compatible?

Yes! A block is available to easily insert the menu shortcode.

---

## Screenshots

1. Admin screen with repeater fields
2. Example frontend menu with styles
3. Customizer option for highlight color

---

## Translation

This plugin is translation-ready and includes a `.pot` file in the `/languages` folder.

---

## Changelog

### 1.0.0

- Initial release with CPT, taxonomy, repeater fields, and Gutenberg block.

---

## Upgrade Notice

### 1.0.0

Initial release.