<?php
  /*
  Plugin Name:       Simple Plugin Selector
  Plugin URI:        https://www.topcode.co.uk/developments/simple-plugin-selector/
  Description:       Improve website performance by loading only the plugins needed for a page.
  Version:           2.0.0
  Requires at least: 6.2
  Requires PHP:      7.4
  Author:            lorro
  Author URI:        https://www.topcode.co.uk/
  License:           GPL v3 or later
  License URI:       https://www.gnu.org/licenses/gpl-3.0.html
  Text Domain:       simple-plugin-selector
  Domain Path:       /languages
  */
        
  defined( 'ABSPATH' ) or die( 'Direct access is not permitted' );
  
  $tsps_version = '2.0.0';
  
  /*
  data scheme
  plugin_load_type: 0 = always, 1 = never, 2 = sometimes
  $tsps_plugins = array (
    'id' => id,
    'slug' => slug, // plugin slug
    'name' => name, // name of plugins
    'load_type' => load_type // 0 = always, 1 = sometimes, 2 = never
  }
  $tsps_pages = array (
    'id' => id,
    'url' => $url, // permalink for page
    'title' => $title, // page title
    'tab' => $tab, // page, post, category, product, product_cat
    'no_loads' => array( id, id, id, ... ) // ids of plugins not required for this page
  }
  */
  
  define( 'TSPS_PATH', plugin_dir_path( __FILE__ ) );
  // eg: TSPS_MU_PLUGINS_PATH = '/home/user/public_html/domain/wp-content/plugins/simple-plugin-selector/';
  
  define( 'TSPS_URL', plugin_dir_url( __FILE__ ) );
  // eg: TSPS_URL = 'http://www.domain.com/wp-content/plugins/simple-plugin-selector/';
  
  // load translations
  add_action( 'init', 'tsps_init' );
  function tsps_init() {
    load_plugin_textdomain( 'simple-plugin-selector', false, TSPS_PATH.'languages/' );
  }
  
  // register scripts
  add_action( 'wp_loaded', 'tsps_register_assets' );
  function tsps_register_assets() {
    global $tsps_version;
    // wp_register_script( $handle, $src, $deps = array(), $version, $in_footer )
    // $src = full url or path relative to wordpress root
    wp_register_script( 'tsps_script', TSPS_URL.'js/admin.js', array(), $tsps_version, true );
    wp_register_style( 'tsps_styles', TSPS_URL.'css/admin.css', array(), $tsps_version );
  }
  
  // enqueue scripts
  // no need to repeat src
  add_action( 'admin_enqueue_scripts', 'tsps_admin_enqueue_assets' );
  function tsps_admin_enqueue_assets () {
    wp_enqueue_script( 'tsps_script' );
    wp_enqueue_style( 'tsps_styles' );
  }
  
  // includes
  require_once( TSPS_PATH.'includes/functions.php' );
  require_once( TSPS_PATH.'includes/pages.php' );
  require_once( TSPS_PATH.'includes/plugins.php' );
  require_once( TSPS_PATH.'includes/settings.php' );
  
  // set default options
  // add_option() will not change the option if it exists
  add_option( 'tsps_items_per_page', 50 );
  add_option( 'tsps_diagnostics', 0 ); // off by default
  add_option( 'tsps_plugins', '' );
  add_option( 'tsps_next_plugin_id', 0 );
  add_option( 'tsps_plugins_settings', '' );
  add_option( 'tsps_pages', '' ); 
  add_option( 'tsps_next_page_id', 0 );
  add_option( 'tsps_pages_settings', '' );
  
  // add setting page to admin menu
  add_action( 'admin_menu', 'tsps_register_menu_items' );
  function tsps_register_menu_items() {
    // add_options_page( page_title, menu_title, capability, menu_slug, function);
    $page_title = esc_html__( 'Settings', 'simple-plugin-selector' );
    $menu_title = esc_html__( 'Simple Plugin Selector', 'simple-plugin-selector' );
    add_options_page ( $page_title, $menu_title, 'manage_options', 'simple-plugin-selector', 'tsps_settings' );
  } // end function
  
  // plugin activation
  register_activation_hook( __FILE__, 'tsps_plugin_activation' );
  function tsps_plugin_activation() {
    // setup the WordPress file system
    require_once ( ABSPATH . 'wp-admin/includes/class-wp-filesystem-base.php' );
    require_once ( ABSPATH . 'wp-admin/includes/class-wp-filesystem-direct.php' );
    $fileSystemDirect = new WP_Filesystem_Direct(false);
    // remove previous version 1.3.2 if present
    $fileSystemDirect->rmdir( WPMU_PLUGIN_DIR.'/simple-plugin-selector/', true ); // "true: means remove contents
    wp_delete_file( WPMU_PLUGIN_DIR.'/simple-plugin-selector.php' ); // no error if it does not exist
    // ensure mu-plugins exists and create it if not
    if ( ! defined( 'FS_CHMOD_DIR' ) ) {
      define( 'FS_CHMOD_DIR', 0755 );
    }      
    $fileSystemDirect->mkdir( WPMU_PLUGIN_DIR );
    // copy filter to mu_plugins
    $source = plugin_dir_path( __FILE__ ).'includes/simple-plugin-selector-filter.php';
    $destination = WPMU_PLUGIN_DIR.'/simple-plugin-selector-filter.php';
    $fileSystemDirect->copy( $source, $destination, true); // 'true' means overwrite if necessary.
  } // end function
  
  // plugin deactivation
  register_deactivation_hook( __FILE__, 'tsps_plugin_deactivation' );
  function tsps_plugin_deactivation() {
    // delete our mu-plugin file
    wp_delete_file( WPMU_PLUGIN_DIR.'/simple-plugin-selector-filter.php' ); // no error if it does not exist
    // do not remove /mu-plugins because another plugin may be using it
  } // end function