<?php
  /*
  Plugin Name:       Simple Plugin Selector - Filter
  Plugin URI:        http://www.topcode.co.uk/developments/simple-plugin-selector/
  Description:       Improve website performance by loading only the plugins needed for a page.
  Version:           2.0.0
  Requires at least: 6.2
  Requires PHP:      7.4
  Author:            lorro
  Author URI:        http://www.topcode.co.uk/
  License:           GPL v3 or later
  License URI:       https://www.gnu.org/licenses/gpl-3.0.html
  */
  
  // This plugin has no translatable strings. so a /languages folder is unnecessary
  
  defined( 'ABSPATH' ) or die( 'Direct access is not permitted' );

  // filter 'option_active_plugins' does not fire in admin context
  add_filter( 'option_active_plugins', 'tsps_filter_plugins' );
  function tsps_filter_plugins( $plugins ) {
    // check that $plugins is an array
    if ( ! is_array( $plugins ) ) {
      return $plugins;
    }
      
    // check that the simple-plugin-selector plugin is active
    if ( ! in_array( 'simple-plugin-selector/simple-plugin-selector.php', $plugins ) ) {
      return $plugins;
    }
    
    // disable filtering in admin context
    // filter 'option_active_plugins' does not fire in admin context, but make sure
    if ( is_admin() ) {
      return $plugins;
    }
    
    // disable if the request is from a cron job
    if ( ! isset( $_SERVER['HTTP_HOST'] ) ) {
      return $plugins;
    }
    
    // its possible to get different urls from the same page load where later calls are by ajax    
    // get the url of the current page    
    // $_SERVER['SCRIPT_URI'] only exists if mod_rewrite is enabled, it is not listed in the documentation & may not exist for XAMPP
    // $_SERVER['HTTP_REFERER'] is not reliable
    // $_SERVER['REQUEST_SCHEME'] is not reliable
    
    if ( isset($_SERVER['HTTPS']) && $_SERVER['HTTPS'] === 'on' ) { 
      $protocol = 'https://';
    } else {  
      $protocol = 'http://';
    }

    // server
    // $_SERVER['HTTP_HOST'] is what the client asked for, not necessarily what the server provided.
    if ( ! isset( $_SERVER['SERVER_NAME'] ) ) { // not set for CRON jobs
      return $plugins;
    }
    $server_name = sanitize_url( wp_unslash( $_SERVER['SERVER_NAME'] ) ); // www.example.com
    // remove possible incorrect protocol
    $server_name = str_replace( 'http://', '' , $server_name );
    $server_name = str_replace( 'https://', '' , $server_name );
    
    // get the requested resource location to the domain
    if ( ! isset( $_SERVER['REQUEST_URI'] ) ) { // not likely but won't work if not set
      return $plugins;
    }
    $uri = sanitize_url( wp_unslash( $_SERVER['REQUEST_URI'] ) ); // ignores querystring if any, /?wc-ajax=get_refreshed_fragments (unknown page)
    
    $url = $protocol.$server_name.$uri; // '#anchor' fragment is not present server side

    // executes several times per page load, so cache the filtered list in $filtered_plugins
    static $filtered_plugins = array(); // only set to $plugins on first call
    static $applicable_url = ''; // the url that applies to the filtered plugins list

    if ( $url == $applicable_url ) {
      // same url, use cached filtered plugins array
      return $filtered_plugins;
    } else {
      // this is a new url
      $filtered_plugins = $plugins;
      $applicable_url = $url;
    }

    // get array of pages
    $tsps_pages = get_option( 'tsps_pages' );
    if ( ! is_array( $tsps_pages ) ) {
      return $plugins;
    }

    // find the current page in page settings
    // get_queried_object_id() doesn't work this early
    // global $wp_query; $wp_query->post->ID - $wp_query is a non-object this early
    // url_to_postid() doesn't work this early
    // so try to match the url
    
    $page_found = false;
    foreach( $tsps_pages as $tsps_page ) {
      if( $url == $tsps_page['url'] ) {
        $page_found = true;
        break;
      }
    }
    if( ! $page_found ) { // the current page is not in $tsps_pages
      return $plugins;
    }

    // get plugin data
    $tsps_plugins = get_option( 'tsps_plugins' );
    if( ! is_array( $tsps_plugins ) ) {
      // plugin types have not been set in tsps settings
      return $plugins;
    }

    // get the no_loads for this page
    $no_loads = $tsps_page['no_loads'];
    if( ! count( $no_loads ) ) {
      return $plugins;
    }
  
    // go through $tsps_plugins
    foreach( $tsps_plugins as $tsps_plugin ) {
      $load_type = $tsps_plugin['load_type'];
      switch ( $load_type ) {
        case 0:
          // "always": leave in $plugins
          break;
        case 1:
          // "never": remove from $plugins
          $slug = $tsps_plugin['slug'];
          foreach ( $plugins as $i => $plugin ) {
            if ( $plugin == $slug ) {
              unset( $plugins[$i] );
              break;
            }
          }
          break;
        case 2:
          // sometimes
          $id = $tsps_plugin['id'];
          $slug = $tsps_plugin['slug'];
          foreach ( $plugins as $i => $plugin ) {
            if( $plugin == $slug ) {
              if( in_array( $id, $no_loads ) ) {
                unset( $plugins[$i] );
              }
              break;
            }
          }
          break;
        default:
      }
    }
    $filtered_plugins = $plugins;
    return $plugins;
    // execution time full filter: 0.50 milliseconds (more for bigger sites)
    // exection time using the cached plugin list: 0.02 milliseconds (same for bigger sites)
  } // end function 