<?php
  // Topcode Website Services
  // Simple Plugin Selector

  defined( 'ABSPATH' ) or die( 'Direct access is not permitted' );

  function tsps_settings() {
    if ( ! current_user_can( 'manage_options' ) )  {
      wp_die( esc_html__( 'You do not have permission to access this page.', 'simple-plugin-selector' ) );
    }
    
    global $tsps_active_tab;
    tsps_update_plugins();
    tsps_update_pages();
    
    // tabs
    $tabs = array(
      'global' => esc_html__( 'Global', 'simple-plugin-selector' ),
      'plugins' => esc_html__( 'Plugins', 'simple-plugin-selector' ),
      'pages' => esc_html__( 'Pages', 'simple-plugin-selector' ),
      'posts' => esc_html__( 'Posts', 'simple-plugin-selector' ),
      'categories' => esc_html__( 'Categories', 'simple-plugin-selector' ),
    );
    // woocommerce page types
    // WooCommerce does not work with Polylang (free version)
    if( tsps_woocommerce_active() ) {
      $tabs['products'] = esc_html__( 'Products', 'simple-plugin-selector' );
      $tabs['product_categories'] = esc_html__( 'Product Categories', 'simple-plugin-selector' );
    }
    // get active tab
    $tsps_active_tab = '';
    if ( isset( $_GET['_wpnonce'] ) ) {
      if ( wp_verify_nonce( sanitize_key( wp_unslash( $_GET['_wpnonce'], '_wpnonce') ) ) ) {
        $tsps_active_tab = isset( $_GET['tab'] ) ? sanitize_text_field( wp_unslash( $_GET['tab'] ) ) : '';
      }
    }
    // verify active_tab
    if( ! in_array( $tsps_active_tab, array_keys( $tabs ) ) ) {
      $tsps_active_tab = 'global';
    }

    tsps_print( '<div class="wrap">' );
    tsps_print( '<h2>'.esc_html__( 'Simple Plugin Selector Settings', 'simple-plugin-selector' ).'</h2>' );    
    tsps_print( '<nav class="nav-tab-wrapper">' );
      
    foreach ( $tabs as $key => $name ) {
      $link = 'options-general.php?page=simple-plugin-selector&tab='.$key;
      $link = wp_nonce_url( $link, -1, '_wpnonce' );
      if ( $key == $tsps_active_tab ) {
        tsps_print( '<a href="'.$link.'" class="nav-tab nav-tab-active">'.$name.'</a>' );
      } else {
        tsps_print( '<a href="'.$link.'" class="nav-tab">'.$name.'</a>' );
      }
    } // end foreach
    tsps_print( '</nav>' ); // end tabs nav

    // settings
    tsps_print( '<form method="post" action="options.php" enctype="multipart/form-data" novalidate="novalidate">' );
    // settings_fields( option_group )
    settings_fields( 'tsps_'.$tsps_active_tab );
    // do_settings_sections( page )
    do_settings_sections( 'tsps_'.$tsps_active_tab );
    submit_button();
    tsps_print( '</form>' );
    tsps_print( '</div>' ); // end wrap div
  } // end function

  // setup the settings

  function tsps_setup_setting( $data ) {
    // add_settings_field( id, title, callable, page, section, array $args )
    $args = array(
      'id' => $data['name'],
      'name' => $data['name'],
      'current_value' => get_option( $data['name'] ),
      'tab' => $data['tab'],
      'help' =>  $data['help']
    );
    add_settings_field( $data['name'], $data['label'], $data['input'], $data['page'], $data['section'], $args );
    // register_setting( option_group, option_name, array $args )
    $args = array(
      'type' => $data['type'],
      'description' => '',
      'sanitize_callback' => $data['validate'],
      'show_in_rest' => false,
      'default' => get_option( $data['name'] )
    ); 
    register_setting( $data['group'], $data['name'], $args );
  }

  add_action( 'admin_init', 'tsps_setup_settings' );
  function tsps_setup_settings() {

    // global tab

    // add_settings_section( id, title, callback, page )
    $section_title = esc_html__( 'Global', 'simple-plugin-selector' );
    add_settings_section( 'tsps_global', $section_title, 'tsps_global_help', 'tsps_global' );

    // maximum items per tab
    $data = array (
      'group' => 'tsps_global',
      'page' => 'tsps_global',
      'section' => 'tsps_global',
      'name' => 'tsps_items_per_page',
      'type' => 'integer',
      'label' => esc_html__( 'Maximum items per page', 'simple-plugin-selector' ),
      'input' => 'tsps_items_per_page_input',
      'tab' => 'global',
      'help' => esc_html__( 'Larger numbers may cause settings tabs to load slowly.', 'simple-plugin-selector' ),
      'validate' => 'tsps_validate_per_page'
    );
    tsps_setup_setting( $data );

    // enable diagnostics
    $data = array (
      'group' => 'tsps_global',
      'page' => 'tsps_global',
      'section' => 'tsps_global',
      'name' => 'tsps_diagnostics',
      'type' => 'integer',
      'label' => esc_html__( 'Activate diagnostics', 'simple-plugin-selector' ),
      'input' => 'tsps_diagnostics_input',
      'tab' => 'global',
      'help' => esc_html__( 'Show ID numbers and plugin data tables. Normally set to "off".', 'simple-plugin-selector' ),
      'validate' => 'tsps_validate_diagnostics'
    );
    tsps_setup_setting( $data );
    
    // plugins tab

    // add_settings_section( id, title, callback, page )
    $section_title = esc_html__( 'Plugins', 'simple-plugin-selector' );
    add_settings_section( 'tsps_plugins', $section_title, 'tsps_plugins_help', 'tsps_plugins' );

    $data = array (
      'group' => 'tsps_plugins',
      'page' => 'tsps_plugins',
      'section' => 'tsps_plugins',
      'name' => 'tsps_plugins_settings',
      'type' => 'array',
      'label' => esc_html__( 'Load type', 'simple-plugin-selector' ),
      'input' => 'tsps_plugins_settings_input',
      'tab' => 'plugins',
      'help' => '',
      'validate' => 'tsps_validate_plugins_settings'
    );
    tsps_setup_setting( $data );

    // pages tab

    // add_settings_section( id, title, callback, page )
    $section_title = __( 'Pages', 'simple-plugin-selector' );
    add_settings_section( 'tsps_pages', $section_title, 'tsps_pages_help', 'tsps_pages' );

    $data = array (
      'group' => 'tsps_pages',
      'page' => 'tsps_pages',
      'section' => 'tsps_pages',
      'name' => 'tsps_pages_settings',
      'type' => 'array',
      'label' => esc_html__( 'Pages', 'simple-plugin-selector' ),
      'input' => 'tsps_pages_settings_input',
      'tab' => 'page',
      'help' => '',
      'validate' => 'tsps_validate_pages_settings'
    );
    tsps_setup_setting( $data );

    // posts tab

    // add_settings_section( id, title, callback, page )
    $section_title = esc_html__( 'Posts', 'simple-plugin-selector' );
    add_settings_section( 'tsps_posts', $section_title, 'tsps_post_help', 'tsps_posts' );

    $data = array (
      'group' => 'tsps_posts',
      'page' => 'tsps_posts',
      'section' => 'tsps_posts',
      'name' => 'tsps_pages_settings',
      'type' => 'array',
      'label' => esc_html__( 'Posts', 'simple-plugin-selector' ),
      'input' => 'tsps_pages_settings_input',
      'tab' => 'post',
      'help' => '',
      'validate' => 'tsps_validate_pages_settings'
    );
    tsps_setup_setting( $data );

    // categories tab

    // add_settings_section( id, title, callback, page )
    $section_title = esc_html__( 'Categories', 'simple-plugin-selector' );
    add_settings_section( 'tsps_categories', $section_title, 'tsps_category_help', 'tsps_categories' );

    $data = array (
      'group' => 'tsps_categories',
      'page' => 'tsps_categories',
      'section' => 'tsps_categories',
      'name' => 'tsps_pages_settings',
      'type' => 'array',
      'label' => esc_html__( 'Categories', 'simple-plugin-selector' ),
      'input' => 'tsps_pages_settings_input',
      'tab' => 'category',
      'help' => '',
      'validate' => 'tsps_validate_pages_settings'
    );
    tsps_setup_setting( $data );

    // products tab

    // add_settings_section( id, title, callback, page )
    $section_title = esc_html__( 'Products', 'simple-plugin-selector' );
    add_settings_section( 'tsps_products', $section_title, 'tsps_product_help', 'tsps_products' );

    $data = array (
      'group' => 'tsps_products',
      'page' => 'tsps_products',
      'section' => 'tsps_products',
      'name' => 'tsps_pages_settings',
      'type' => 'array',
      'label' => esc_html__( 'Products', 'simple-plugin-selector' ),
      'input' => 'tsps_pages_settings_input',
      'tab' => 'product',
      'help' => '',
      'validate' => 'tsps_validate_pages_settings'
    );
    tsps_setup_setting( $data );

    // product_categories tab

    // add_settings_section( id, title, callback, page )
    $section_title = esc_html__( 'Product Categories', 'simple-plugin-selector' );
    add_settings_section( 'tsps_product_categories', $section_title, 'tsps_product_cat_help', 'tsps_product_categories' );

    $data = array (
      'group' => 'tsps_product_categories',
      'page' => 'tsps_product_categories',
      'section' => 'tsps_product_categories',
      'name' => 'tsps_pages_settings',
      'type' => 'array',
      'label' => esc_html__( 'Product Categories', 'simple-plugin-selector' ),
      'input' => 'tsps_pages_settings_input',
      'tab' => 'product_cat',
      'help' => '',
      'validate' => 'tsps_validate_pages_settings'
    );
    tsps_setup_setting( $data );

  } // end function

  // input functions

  function tsps_items_per_page_input( $args ) {
    $id = $args['id'];
    $name = $args['name'];
    $tsps_items_per_page = $args['current_value'];
    tsps_print( '<select name="'.$name.'">' );
      tsps_print_option( 20, $tsps_items_per_page, '20' );
      tsps_print_option( 50, $tsps_items_per_page, '50' );
      tsps_print_option( 100, $tsps_items_per_page, '100' );
      tsps_print_option( 200, $tsps_items_per_page, '200' );
      tsps_print_option( 500, $tsps_items_per_page, '500' );
    tsps_print( '</select>' );
    tsps_print_help( $args );
  } // end function

  function tsps_diagnostics_input( $args ) {
    $id = $args['id'];
    $name = $args['name'];
    $current_value = $args['current_value'];
    // tsps_print_checkbox( $value, $checked, $name, $text )
    tsps_print_checkbox( 1, $current_value, 'tsps_diagnostics' );
    tsps_print_help( $args );
  } // end function
  
  function tsps_plugins_settings_input( $args ) {
    $tsps_diagnostics = get_option( 'tsps_diagnostics' );
    $id = $args['id'];
    $name = $args['name'];
    $tsps_plugins = get_option( 'tsps_plugins' );
    if( ! count( $tsps_plugins ) ) {
      tsps_print( '<p class="tsps_help">'.esc_html__( 'There are no active plugins.', 'simple-plugin-selector' ).'</p>' );
      return;
    }
    usort( $tsps_plugins, 'tsps_sort_plugins_by_name' );
    tsps_print( '<table class="tsps_table plugins">' );
    tsps_print( '<thead>' );
    tsps_print( '<tr>' );
    if( $tsps_diagnostics ) {
      tsps_print( '<th class="narrow">'.esc_html__( 'ID', 'simple-plugin-selector' ).'</th>' );
    }
    tsps_print( '<th>'.esc_html__( 'Plugin', 'simple-plugin-selector' ).'</th>' );
    tsps_print( '<th class="narrow">'.esc_html__( 'Always', 'simple-plugin-selector' ).'</th>' );
    tsps_print( '<th class="narrow">'.esc_html__( 'Never', 'simple-plugin-selector' ).'</th>' );
    tsps_print( '<th class="narrow">'.esc_html__( 'Sometimes', 'simple-plugin-selector' ).'</th>' );
    tsps_print( '</tr>' );
    tsps_print( '</thead>' );
    tsps_print( '<tbody>' );
    foreach( $tsps_plugins as $tsps_plugin ) {
      $load_type = $tsps_plugin['load_type']; 
      $group_name = 'tsps_plugins_settings['.$tsps_plugin['id'].']';
      tsps_print( '<tr>' );
      if( $tsps_diagnostics ) {
        tsps_print( '<td>'.$tsps_plugin['id'].'</td>' );
      }
      tsps_print( '<td>'.$tsps_plugin['name'].'</td>' );
      tsps_print_radio_button_cell( 0, $load_type, $group_name );
      tsps_print_radio_button_cell( 1, $load_type, $group_name );
      tsps_print_radio_button_cell( 2, $load_type, $group_name );
      tsps_print( '</tr>' );
    }
    tsps_print( '</tbody>' );
    tsps_print( '</table>' );
    tsps_print_help( $args );
    
    if( $tsps_diagnostics ) {
      require_once( 'plugins-table.php' );
    }
  } // end function

  function tsps_pages_settings_input( $args ) {
    global $tsps_active_tab;
    $tsps_diagnostics = get_option( 'tsps_diagnostics' );
    
    $id = $args['id'];
    $name = $args['name'];
    $tsps_pages = get_option( 'tsps_pages' );
    $tab = $args['tab'];

    // count how many plugins have been set to load "sometimes"
    $tsps_plugins = get_option( 'tsps_plugins' );
    $nr_plugins = 0;
    foreach( $tsps_plugins as $index => $tsps_plugin ) {
      if( $tsps_plugin['load_type'] == 2 ) {
        $nr_plugins++;
      }
    }
    if( !$nr_plugins ) {
      tsps_print( '<p class="tsps_help">'.esc_html__( 'No plugins have been set to load "Sometimes". These can be set on the Plugins tab.', 'simple-plugin-selector' ).'</p>' );
      return;
    }
    usort( $tsps_plugins, 'tsps_sort_plugins_by_name' );

    // count how many items there are for this tab
    $nr_items = 0;
    foreach( $tsps_pages as $tsps_page ) {
      if( $tsps_page['tab'] == $tab ) {
        $nr_items++;
      }
    }
    if( ! $nr_items ) {
      tsps_print( '<p class="tsps_help">'.esc_html__( 'No pages.', 'simple-plugin-selector' ).'</p>' );
      return;
    }
    usort( $tsps_pages, 'tsps_sort_pages_by_title' );
    
    $tsps_items_per_page = get_option( 'tsps_items_per_page' );
    $nr_pages = ceil( $nr_items / $tsps_items_per_page );

    // "Copy settings" button:
    if( $nr_items > 1 ) {
      tsps_print( '<p><button class="button button-secondary no_submit" onclick="tsps_copy_settings()">' );
      tsps_print( esc_html__( 'Copy settings', 'simple-plugin-selector' ) );
      tsps_print( '</button></p>' );
      tsps_print( '<p class="tsps_help">' );
      /* translators: %$s: type of page */
      tsps_print( esc_html__( 'Copy the settings for the first item to all the other items in the list.', 'simple-plugin-selector' ) );
      tsps_print( ' '.esc_html__( 'There is no "undo", although you can navigate away without saving.', 'simple-plugin-selector' ).'</p>' );
      // "Copy complete" note
      tsps_print( '<p id="tsps_alert">' );
      if( $nr_pages == 1 ) {
        tsps_print( esc_html__( 'Copy complete. Don\'t forget to "Save Changes".', 'simple-plugin-selector' ) );
      } else {
        tsps_print( esc_html__( 'Copy complete. Don\'t forget to "Save Changes" for each page.', 'simple-plugin-selector' ) );
      }
      tsps_print( '</p>' );
    } // end show "Copy settings" button

    // get page number
    $page_nr = 1;
    if ( isset( $_GET['_wpnonce'] ) ) {
      if ( wp_verify_nonce( sanitize_key( wp_unslash( $_GET['_wpnonce'], '_wpnonce') ) ) ) {
        $page_nr = isset( $_GET['page_nr'] ) ? sanitize_text_field( wp_unslash( $_GET['page_nr'] ) ) : 1;
      }
    } 
    // verify $page_nr
    $page_nr = intval( $page_nr );
    if( $page_nr < 1 || $page_nr > $nr_pages ) {
      $page_nr = 1;
    }
    $item_nr = 0;
    foreach( $tsps_pages as $tsps_page ) {
      if( $tsps_page['tab'] != $tab ) {
        continue;
      }
      if( $item_nr < ( $page_nr - 1 ) * $tsps_items_per_page ) {
        $item_nr++;
        continue;
      }
      if( $item_nr >= $page_nr * $tsps_items_per_page ) {
        break;
      }
      $page_title = $tsps_page['title'];
      $url = $tsps_page['url'];
      tsps_print( '<h4>'.$page_title.'</h4>' );
      tsps_print( '<div class="tsps_url">URL: <a href="'.$url.'" target="_blank">'.$url.'</a></div>' );
      tsps_print( '<table class="tsps_table pages">' );
      tsps_print( '<thead>' );
      tsps_print( '<tr>' );
      if( $tsps_diagnostics ) {
        tsps_print( '<th class="narrow">'.esc_html( 'ID', 'simple-plugin-selector' ).'</th>' );
      }
      tsps_print( '<th>'.esc_html__( 'Plugin', 'simple-plugin-selector' ).'</th>' );
      tsps_print( '<th class="narrow">'.esc_html__( 'Load', 'simple-plugin-selector' ).'</th>' );
      tsps_print( '<th class="narrow">'.esc_html__( 'Don\'t load', 'simple-plugin-selector' ).'</th>' );
      tsps_print( '</tr>' );
      tsps_print( '</thead>' );
      tsps_print( '<tbody>' );
      $plugin_row = 0;
      foreach( $tsps_plugins as $j => $tsps_plugin ) {
        if( $tsps_plugin['load_type'] != 2 ) {
          continue;
        }
        tsps_print( '<tr class="plugin_row_'.$plugin_row.'">' );
        if( $tsps_diagnostics ) {
          tsps_print( '<td>'.$tsps_plugin['id'].'</td>' );
        }
        tsps_print( '<td>'.$tsps_plugin['name'].'</td>' );
        $group_name = 'tsps_pages_settings['.$tsps_page['id'].']['.$tsps_plugin['id'].']';
        $no_load = in_array( $tsps_plugin['id'], $tsps_page['no_loads'] ) ? 1 : 0;
        tsps_print_radio_button_cell( 0, $no_load, $group_name );
        tsps_print_radio_button_cell( 1, $no_load, $group_name );
        tsps_print( '</tr>' );
        $plugin_row++;
      }
      tsps_print( '</tbody>' );
      tsps_print( '</table>' );
      $item_nr++;
    }

    // pagination
    if( $nr_pages > 1 ) {
      $this_page_nr = $page_nr;
      tsps_print( '<div class="tsps_setting_nrs">'.esc_html( 'Page No: ', 'simple-plugin-selector' ) );
      for( $page_nr = 1; $page_nr <= $nr_pages; $page_nr++ ) {
        $is_current = $this_page_nr == $page_nr ? 'current' : '';
        $link = '?page=simple-plugin-selector&tab='.$tsps_active_tab.'&page_nr='.$page_nr;
        $link = wp_nonce_url( $link, -1, '_wpnonce' );
        tsps_print( '<a href="'.$link.'" class="tsps_page_nr '.$is_current.'">'.$page_nr.'</a>' );
      }
      tsps_print( '</div>' );
    }

    if( $tsps_diagnostics ) {
      require_once( 'pages-table.php' );
    }
  } // end function

  // validate
  
  function tsps_validate_per_page( $value ) {
    $value = intval( $value );
    if( $value < 20 ) {
      $value = 20;
    }
    if( $value > 500 ) {
      $value = 500;
    }
    return $value;
  } // end function

  function tsps_validate_diagnostics( $value ) {
    $value = intval( $value );
    if( $value != 0 && $value != 1 ) {
      $value = 0; // off by default
    }
    return $value;
  } // end function
  
  function tsps_validate_plugins_settings( $tsps_plugins_settings ) {
    $tsps_plugins = get_option( 'tsps_plugins' );
    foreach( $tsps_plugins_settings as $plugin_id => $load_type ) {
      foreach( $tsps_plugins as $i => $tsps_plugin ) {
        if( $plugin_id == $tsps_plugin['id'] ) {
          $tsps_plugins[$i]['load_type'] = $load_type;
          break;
        }
      }
    }
    update_option( 'tsps_plugins', $tsps_plugins );
    return $tsps_plugins_settings;
  } // end function
  
  function tsps_validate_pages_settings( $tsps_pages_settings ) {
    // any entries having the same index overwrite existing entries if present
    // other post_ids remain unchanged
    $tsps_pages = get_option( 'tsps_pages' );
    foreach( $tsps_pages_settings as $page_id => $settings ) {
      foreach( $tsps_pages as $i => $tsps_page ) {
        if( $page_id == $tsps_page['id'] ) {
          $no_loads = array();
          foreach( $settings as $plugin_id => $setting ) {
            if( $setting ) {
              $no_loads[] = $plugin_id;
            }
          }
          $tsps_pages[$i]['no_loads'] = $no_loads;
          break;
        }
      }
    }
    update_option( 'tsps_pages', $tsps_pages );
    return $tsps_pages_settings;
  } // end function

  // show help text

  function tsps_global_help( $args ) {
    tsps_print( '<p class="tsps_help">'.esc_html__( 'Simple Plugin Selector works on front-side pages only.', 'simple-plugin-selector' ).'</p>' );
    tsps_print( '<p class="tsps_help">'.esc_html__( 'Activate or deactivate the plugin filter on the:', 'simple-plugin-selector' ).'<br>' );
    tsps_print( __( 'Dashboard &gt; Plugins &gt; Installed Plugins page.', 'simple-plugin-selector' ).'</p>' );
    tsps_print( '<p class="tsps_help">'.esc_html__( 'If you have cache or optimize plugins, clear them after changing any settings.', 'simple-plugin-selector' ).'</p>' );
  } // end function

  function tsps_plugins_help( $args ) {
    tsps_print( '<p class="tsps_help">'.esc_html__( 'Simple Plugin Selector works on front-side pages only.', 'simple-plugin-selector' ).'</p>' );
    tsps_print( '<p class="tsps_help">'.esc_html__( 'Set which plugins should load on every page, which should never load and which should load only on some pages.', 'simple-plugin-selector' ).'</p>' );
    tsps_print( '<p class="tsps_help">'.esc_html__( 'Use the other tabs to set which "Sometimes" plugins should load on which page.', 'simple-plugin-selector' ).'</p>' );
  } // end function

  function tsps_pages_help( $args ) {
    tsps_print( '<p class="tsps_help">'.esc_html__( 'Simple Plugin Selector works on front-side pages only.', 'simple-plugin-selector' ).'</p>' );
    tsps_print( '<p class="tsps_help">'.esc_html__( "Set which plugins should load on which pages.", 'simple-plugin-selector' ).'</p>' );
    tsps_print( '<p class="tsps_help">'.esc_html__( 'Only plugins set to "Sometimes" on the Plugins tab will appear here.', 'simple-plugin-selector' ).'</p>' );
  } // end function

  function tsps_post_help( $args ) {
    tsps_print( '<p class="tsps_help">'.esc_html__( 'Simple Plugin Selector works on front-side pages only.', 'simple-plugin-selector' ).'</p>' );
    tsps_print( '<p class="tsps_help">'.esc_html__( "Set which plugins should load on which post pages.", 'simple-plugin-selector' ).'</p>' );
    tsps_print( '<p class="tsps_help">'.esc_html__( 'Only plugins set to "Sometimes" on the Plugins tab will appear here.', 'simple-plugin-selector' ).'</p>' );
  } // end function

  function tsps_category_help( $args ) {
    tsps_print( '<p class="tsps_help">'.esc_html__( 'Simple Plugin Selector works on front-side pages only.', 'simple-plugin-selector' ).'</p>' );
    tsps_print( '<p class="tsps_help">'.esc_html__( "Set which plugins should load on which category pages.", 'simple-plugin-selector' ).'</p>' );
    tsps_print( '<p class="tsps_help">'.esc_html__( 'Only plugins set to "Sometimes" on the Plugins tab will appear here.', 'simple-plugin-selector' ).'</p>' );
  } // end function

  function tsps_product_help( $args ) {
    tsps_print( '<p class="tsps_help">'.esc_html__( 'Simple Plugin Selector works on front-side pages only.', 'simple-plugin-selector' ).'</p>' );
    tsps_print( '<p class="tsps_help">'.esc_html__( "Set which plugins should load on which product pages.", 'simple-plugin-selector' ).'</p>' );
    tsps_print( '<p class="tsps_help">'.esc_html__( 'Only plugins set to "Sometimes" on the Plugins tab will appear here.', 'simple-plugin-selector' ).'</p>' );
  } // end function

  function tsps_product_cat_help( $args ) {
    tsps_print( '<p class="tsps_help">'.esc_html__( 'Simple Plugin Selector works on front-side pages only.', 'simple-plugin-selector' ).'</p>' );
    tsps_print( '<p class="tsps_help">'.esc_html__( "Set which plugins should load on which product category pages.", 'simple-plugin-selector' ).'</p>' );
    tsps_print( '<p class="tsps_help">'.esc_html__( 'Only plugins set to "Sometimes" on the Plugins tab will appear here.', 'simple-plugin-selector' ).'</p>' );
  } // end function

  function tsps_print_help( $args ) {
    $help = $args['help'];
    if ( $help ) {
      tsps_print( '<p class="tsps_help">'.$help.'</p>' );
    }
  } // end function