<?php
  // Topcode Website Services
  // Simple Plugin Selector

  defined( 'ABSPATH' ) or die( 'Direct access is not permitted' );

  // update plugins data

  function tsps_update_plugins() {
    $tsps_plugins = get_option( 'tsps_plugins' ); 
    if( gettype( $tsps_plugins) != 'array' ) {
      $tsps_plugins = array();
    }
    
    // remove entries in $tsps_plugins if the plugin is no longer active
    $active_plugins = get_option( 'active_plugins' );
    foreach( $tsps_plugins as $i => $tsps_plugin ) {
      $found = false;
      foreach( $active_plugins as $slug ) {
        if( $tsps_plugin['slug'] == $slug ) {
          $found = true;
          break;
        }
      }
      if( ! $found ) {
        unset( $tsps_plugins[$i] );
      }
    }
    
    // if all plugins are unset, $tsps_plugins will be undefined
    if( ! isset( $tsps_plugins) ) { 
      $tsps_plugins = array();
    }
    if( gettype( $tsps_plugins) != 'array' ) {
      $tsps_plugins = array();
    }
    // add entries in $tsps_plugins for new plugins
    foreach( $active_plugins as $slug ) {
      $found = false;
      foreach( $tsps_plugins as $tsps_plugin ) {
        if( $slug == $tsps_plugin['slug'] ) {
          $found = true;
          continue;
        }
      }
      if( ! $found ) {
        // eg: WP_PLUGIN_DIR = /home/user/public_html/domain/wp-content/plugins (no trailing slash)
        $plugin_path = WP_PLUGIN_DIR.'/'.$slug; // absolute path to plugin file
        $plugin_data = get_plugin_data( $plugin_path, false, false );
        $id = get_option( 'tsps_next_plugin_id' );
        update_option( 'tsps_next_plugin_id', $id + 1 );
        $tsps_plugin = array(
          'id' => $id ,
          'slug' => $slug,
          'name' => $plugin_data['Name'],
          'load_type' => 0 // defaults to 0 for "always"
        );
        $tsps_plugins[] = $tsps_plugin;
      }
    }
    update_option( 'tsps_plugins', $tsps_plugins );
 } // end function