<?php
  // Topcode Website Services
  // Simple Plugin Selector

  defined( 'ABSPATH' ) or die( 'Direct access is not permitted' );
  
  function tsps_update_pages() {
    $pages = array();
    
    $post_types = array( 'page', 'post' );
    if( tsps_woocommerce_active() ) {
      $post_types[] = 'product';
    }
    $args = array(
      'numberposts' => -1,
      'post_type' => $post_types,
      'post_status' => 'publish',
    );
    $posts = get_posts( $args );
    foreach( $posts as $post ) {
      $page = array(
        'url' => get_permalink( $post->ID ),
        'title' => $post->post_title,
        'tab' => $post->post_type
      );
      $pages[] = $page;
    }
    
    $taxonomies = array( 'category' );
    if( tsps_woocommerce_active() ) {
      $taxonomies[] = 'product_cat';
    }
    $args = array(
      'taxonomy'   => $taxonomies,
      'hide_empty' => true
    );
    $terms = get_terms( $args );
    if( ! is_wp_error( $terms ) ) {
      foreach( $terms as $term ) {
        $page = array(
          'url' => get_category_link( $term ),
          'title' => 'Taxonomy for term: '.$term->name,
          'tab' => $term->taxonomy
        );
        $pages[] = $page;
      }
    }
  
    // remove entries in $tsps_pages if the page is no longer published
    $tsps_pages = get_option( 'tsps_pages' );
    if( gettype( $tsps_pages) != 'array' ) {
      $tsps_pages = array();
    }
    foreach( $tsps_pages as $i => $tsps_page ) {
      $found = false;
      foreach( $pages as $page ) {
        if( $tsps_page['url'] == $page['url'] ) {
          $found = true;
          break;
        }
      }
      if( ! $found ) {
        unset( $tsps_pages[$i] );
      }
    }

    // if all pages are unset, $tsps_pages will be undefined
    if( ! isset( $tsps_pages ) ) { 
      $tsps_pages = array();
    }
    // add any new pages
    if( gettype( $tsps_pages) != 'array' ) {
      $tsps_pages = array();
    }
    foreach( $pages as $page ) {
      $found = false;
      foreach( $tsps_pages as $tsps_page ) {
        if( $page['url'] == $tsps_page['url'] ) {
          $found = true;
          break;
        }
      }
      if( ! $found ) {
        $id = get_option( 'tsps_next_page_id' );
        update_option( 'tsps_next_page_id', $id + 1 );
        $new_page = array();
        $new_page['id'] = $id;
        $new_page['url'] = $page['url'];
        $new_page['title'] = $page['title'];
        $new_page['tab'] = $page['tab'];
        $new_page['no_loads'] = array();
        $tsps_pages[] = $new_page;
      }
    }
    
    update_option( 'tsps_pages', $tsps_pages );
  } // end function