<?php
  // Topcode Website Services
  // Simple Plugin Selector

  defined( 'ABSPATH' ) or die( 'Direct access is not permitted' );

  // print a radio button
  // if the value is the current_value, the button is selected
  function tsps_print_radio_button_cell( $value, $current_value, $name ) {
    tsps_print( '<td>' );
    if ( $value == $current_value ) {
      tsps_print( '<input type="radio" name="'.$name.'" value="'.$value.'" class="tsps_radio" checked="checked">' );
    } else {
      tsps_print( '<input type="radio" name="'.$name.'" value="'.$value.'" class="tsps_radio">' );
    }
    tsps_print( '</td>' );
  } // end function
  
  // print a checkbox
  // if $checked is true, the checkbox is checked
  function tsps_print_checkbox( $value, $checked, $name ) {
    if ( $checked ) {
      tsps_print( '<input type="checkbox" name="'.$name.'" value="'.$value.'" checked="checked">' );
    } else {
      tsps_print( '<input type="checkbox" name="'.$name.'" value="'.$value.'">' );
    }
  } // end function

  // print a select option
  // if the option is the current_value, the option is selected
  function tsps_print_option( $value, $current_value, $text ) {
    if ( $value == $current_value ) {
      tsps_print ('<option value="'.$value.'" selected="selected">'.$text.'</option>' );
    } else {
      tsps_print ( '<option value="'.$value.'">'.$text.'</option>' );
    }
  } // end function
  
  function tsps_sort_plugins_by_name( $a, $b ) {
    if ( $a['name'] == $b['name'] ) return 0;
    return ( $a['name'] < $b['name'] ) ? -1 : 1;
  } // end function

  function tsps_sort_pages_by_title( $a, $b ) {
    if ( $a['title'] == $b['title'] ) return 0;
    return ( $a['title'] < $b['title'] ) ? -1 : 1;
  } // end function
  
  function tsps_woocommerce_active() {
    $plugins = get_option( 'active_plugins' );
    return in_array( 'woocommerce/woocommerce.php', $plugins );
  } // end function
  
  function tsps_print( $html ) {
    global $tsps_allowed_html;
    if ( ! isset( $tsps_allowed_html ) ) {
      $tsps_allowed_html = array(
        'a'            => array(
          'href'       => array(),
          'target'     => array(),
          'class'      => array()
        ),
        'br'           => array(),
        'button'       => array(
          'id'         => array(),
          'class'      => array(),
          'onclick'    => array()
        ),
        'div'          => array(
          'id'         => array(),
          'class'      => array()
        ),
        'form'         => array(
          'method'     => array(),
          'action'     => array(),
          'enctype'    => array(),
          'novalidate' => array()
        ),
        'h2'           => array(),
        'h3'           => array(),
        'h4'           => array(),
        'input'        => array(
          'type'       => array(),
          'id'         => array(),
          'name'       => array(),
          'value'      => array(),
          'class'      => array(),
          'checked'    => array()
        ),
        'label'        => array(
          'for'        => array()
        ),
        'nav'          => array(
          'class'      => array()
        ),
        'option'       => array(
          'selected'   => array(),
          'value'      => array()
        ),
        'p'            => array(
          'class'      => array(),
          'id'         => array()
        ),
        'script'       => array(),
        'select'       => array(
          'name'       => array(),
          'class'      => array()
        ),
        'span'         => array(
          'id'         => array(),
          'class'      => array()
        ),
        'table'        => array(
          'class'      => array()
        ),
        'tbody'        => array(
          'class'      => array()
        ),
        'td'           => array(
          'class'      => array()
        ),
        'th'           => array(
          'class'      => array()
        ),
        'thead'        => array(
          'class'      => array()
        ),
        'tr'           => array(
          'class'      => array()
        )
      );
    }
    global $tsps_allowed_protocols;
    if( ! isset( $tsps_allowed_protocols ) ) {
      $tsps_allowed_protocols = array();
    }
    print wp_kses( $html.PHP_EOL, $tsps_allowed_html, $tsps_allowed_protocols );
  } // end function