jQuery(document).ready(function($) {
    // Disable weekends (Saturday and Sunday)
    $('#simple-booking-system-date').attr('min', new Date().toISOString().split('T')[0]);
    $('#simple-booking-system-date').on('input', function() {
        let selectedDate = new Date($(this).val());
        let day = selectedDate.getDay();
        if (day === 0 || day === 6) {
            $(this).val('');
            alert(simple_booking_system_ajax.weekend_message);
        }
    });

    // Handle date change and get available time slots
    $('#simple-booking-system-date').change(function() {
        let selectedDate = $(this).val();
        if (!selectedDate) return;
        
        $.post(simple_booking_system_ajax.ajax_url, {
            action: 'simple_booking_system_get_available_times',
            date: selectedDate,
            nonce: simple_booking_system_ajax.nonce
        }, function(response) {
            $('#simple-booking-system-time').html(response);
        }).fail(function() {
            $('#simple-booking-system-time').html('<option value="">Failed to load time slots</option>');
        });
    });

    // Form submission
    $('#simple-booking-system-booking-form').submit(function(e) {
        e.preventDefault();
        var form = $(this);
        
        $.post(simple_booking_system_ajax.ajax_url, form.serialize() + '&action=simple_booking_system_handle_booking', function(response) {
            if (response.success) {
                $('#simple-booking-system-response')
                    .removeClass('text-danger')
                    .addClass('text-success')
                    .html(response.data.message)
                    .fadeIn();
                form[0].reset();
                $('#simple-booking-system-time').html('');
            } else {
                $('#simple-booking-system-response')
                    .removeClass('text-success')
                    .addClass('text-danger')
                    .html(response.data.message)
                    .fadeIn();
            }
        }).fail(function() {
            $('#simple-booking-system-response')
                .removeClass('text-success')
                .addClass('text-danger')
                .html('An error occurred while processing your request. Please try again.')
                .fadeIn();
        });
    });
});