<?php
if ( ! defined( 'ABSPATH' ) ) {
    exit;
}
?>

<!-- Calendar click modal -->
<!-- Data is dynamically populated via JavaScript -->
<div id="modale-prenotazione" style="display:none; position: fixed; top: 0; left: 0; width:100%; height:100%; background: rgba(0,0,0,0.6); z-index: 1000;">
    <div class="modale-contenuto">
        <button id="chiudi-modale" class="button chiudi-modale" aria-label="Chiudi">×</button>

        <h2 id="modale-titolo"></h2>

        <div class="modale-corpo">
            <div class="modale-dettagli">
                <p><strong><?php esc_html_e('Email:', 'simple-bike-rental'); ?></strong> <span id="modale-email"></span></p>
                <p><strong><?php esc_html_e('Phone:', 'simple-bike-rental'); ?></strong> <span id="modale-telefono"></span></p>
                <p><strong><?php esc_html_e('Bicycle:', 'simple-bike-rental'); ?></strong> <span id="modale-bici-nome"></span></p>
                <p><strong><?php esc_html_e('Period:', 'simple-bike-rental'); ?></strong> <span id="modale-periodo"></span></p>
                <div class="modale-azioni">
                    <!--
                    Note: The cancellation nonce is passed via wp_localize_script()
                    and validated on the PHP side in the AJAX function (simpbire_elimina_prenotazione_admin).
                    It's not necessary to add a hidden field here.
                    -->
                    <button id="elimina-prenotazione-btn" class="button elimina-btn" data-id=""><?php esc_html_e('Delete', 'simple-bike-rental'); ?></button>
                    <a href="#" id="modale-link-edit" class="button button-secondary"><?php esc_html_e('Edit Booking', 'simple-bike-rental'); ?></a>
                </div>
            </div>
            <div class="modale-img">
                <img id="modale-bici-img" src="" alt="" style="display: none;" />
            </div>
        </div>
    </div>
</div>
