<?php
if ( ! defined( 'ABSPATH' ) ) {
    exit;
}

/**
 * General settings page for the Simple Bike Rental plugin.
 */
$simpbire_nome_opzione_intervallo = 'simpbire_minuti_intervallo_prenotazioni';
$simpbire_nome_opzione_redirect = 'simpbire_pagina_redirect_id';
$simpbire_nome_opzione_pagina_messaggi = 'simpbire_pagina_messaggi_token_id';
$simpbire_nome_opzione_email_nome = 'simpbire_email_nome_mittente';
$simpbire_nome_opzione_email_indirizzo = 'simpbire_email_indirizzo_mittente';
$simpbire_nome_opzione_elimina_tabelle = 'simpbire_elimina_tabelle_plugin';
$simpbire_nome_opzione_valuta = 'simpbire_valuta_pagamento';

$simpbire_valute_supportate = [
    'eur', 'usd', 'gbp', 'cad', 'aud', 'chf', 'sek', 'dkk', 'nok', 'pln', 'czk',
];

// Saving
if (isset($_POST['salva_impostazioni'])) {
    // Verify current user capabilities and nonce for CSRF protection before saving settings.
    if (!current_user_can('manage_options')) {
        wp_die(esc_html__('You do not have permission to change these settings.', 'simple-bike-rental'));
    }

    if (!isset($_POST['simpbire_nonce']) || !wp_verify_nonce(sanitize_text_field(wp_unslash($_POST['simpbire_nonce'])), 'salva_impostazioni_noleggio')) {
        wp_die(esc_html__('Invalid nonce. Please reload the page and try again.', 'simple-bike-rental'));
    }

    // Sanitize and save plugin options to the database.
    update_option($simpbire_nome_opzione_intervallo, isset($_POST['intervallo_minuti']) ? intval($_POST['intervallo_minuti']) : '');
    update_option($simpbire_nome_opzione_email_nome, isset($_POST['email_nome_mittente']) ? sanitize_text_field(wp_unslash($_POST['email_nome_mittente'])) : '');
    update_option($simpbire_nome_opzione_redirect, isset($_POST['pagina_redirect_id']) ? intval($_POST['pagina_redirect_id']) : '');
    update_option($simpbire_nome_opzione_pagina_messaggi, isset($_POST['pagina_messaggi_token_id']) ? intval($_POST['pagina_messaggi_token_id']) : '');
    update_option($simpbire_nome_opzione_email_indirizzo, isset($_POST['email_indirizzo_mittente']) ? sanitize_email(wp_unslash($_POST['email_indirizzo_mittente'])) : '');
    
    $simpbire_valuta = isset($_POST['valuta_pagamento']) ? sanitize_text_field(wp_unslash($_POST['valuta_pagamento'])) : 'eur';
    if (!in_array($simpbire_valuta, $simpbire_valute_supportate, true)) {
        $simpbire_valuta = 'eur';
    }
    
    update_option($simpbire_nome_opzione_valuta, $simpbire_valuta);
    update_option($simpbire_nome_opzione_elimina_tabelle, isset($_POST['elimina_tabelle_plugin']) ? 1 : 0);

    echo '<div class="notice notice-success is-dismissible"><p>' . esc_html__('Settings saved successfully.', 'simple-bike-rental') . '</p></div>';
}

// Retrieving values
$simpbire_intervallo_minuti = get_option($simpbire_nome_opzione_intervallo, 0);
$simpbire_pagina_redirect_id = get_option($simpbire_nome_opzione_redirect, '');
$simpbire_pagina_messaggi_token_id = get_option($simpbire_nome_opzione_pagina_messaggi, '');
$simpbire_email_nome_mittente = get_option($simpbire_nome_opzione_email_nome, get_bloginfo('name'));
$simpbire_email_indirizzo_mittente = get_option($simpbire_nome_opzione_email_indirizzo, get_bloginfo('admin_email'));
$simpbire_elimina_tabelle_plugin = get_option($simpbire_nome_opzione_elimina_tabelle, 0);
$simpbire_valuta_pagamento = get_option($simpbire_nome_opzione_valuta, 'eur');

$simpbire_pagine = get_pages();
?>

<div class="wrap">
    <h1><?php esc_html_e('Rental Settings', 'simple-bike-rental'); ?></h1>
    <form method="post" action="">
        <table class="form-table">
            <!-- Minimum interval -->
            <tr>
                <th scope="row"><label for="intervallo_minuti"><?php esc_html_e('Minimum interval between bookings (in minutes)', 'simple-bike-rental'); ?></label></th>
                <td>
                    <input name="intervallo_minuti" type="number" id="intervallo_minuti" value="<?php echo esc_attr($simpbire_intervallo_minuti); ?>" class="small-text" min="0" step="1">
                    <p class="description"><?php esc_html_e('Set a minimum time between one booking and the next.', 'simple-bike-rental'); ?></p>
                </td>
            </tr>

            <!-- Redirect -->
            <tr>
                <th scope="row"><label for="pagina_redirect_id"><?php esc_html_e('Post-booking redirect page', 'simple-bike-rental'); ?></label></th>
                <td>
                    <select name="pagina_redirect_id" id="pagina_redirect_id">
                        <option value=""><?php esc_html_e('— No redirect —', 'simple-bike-rental'); ?></option>
                        <?php foreach ($simpbire_pagine as $simpbire_pagina): ?>
                            <option value="<?php echo esc_attr($simpbire_pagina->ID); ?>" <?php selected($simpbire_pagina_redirect_id, $simpbire_pagina->ID); ?>>
                                <?php echo esc_html($simpbire_pagina->post_title); ?>
                            </option>
                        <?php endforeach; ?>
                    </select>
                    <p class="description"><?php esc_html_e('Page to display after a completed booking.', 'simple-bike-rental'); ?></p>
                </td>
            </tr>

            <!-- Page for confirmation messages -->
            <tr>
                <th scope="row"><label for="pagina_messaggi_token_id"><?php esc_html_e('Page for confirmation messages', 'simple-bike-rental'); ?></label></th>
                <td>
                    <select name="pagina_messaggi_token_id" id="pagina_messaggi_token_id">
                        <option value=""><?php esc_html_e('- No page selected -', 'simple-bike-rental'); ?></option>
                        <?php foreach ($simpbire_pagine as $simpbire_pagina): ?>
                            <option value="<?php echo esc_attr($simpbire_pagina->ID); ?>" <?php selected($simpbire_pagina_messaggi_token_id, $simpbire_pagina->ID); ?>>
                                <?php echo esc_html($simpbire_pagina->post_title); ?>
                            </option>
                        <?php endforeach; ?>
                    </select>
                    <p class="description"><?php esc_html_e('Select the page to display booking confirmation messages.', 'simple-bike-rental'); ?></p>
                </td>
            </tr>

            <!-- Payment currency -->
            <tr>
                <th scope="row"><label for="valuta_pagamento"><?php esc_html_e('Payment currency', 'simple-bike-rental'); ?></label></th>
                <td>
                    <select name="valuta_pagamento" id="valuta_pagamento">
                        <option value="eur" <?php selected($simpbire_valuta_pagamento, 'eur'); ?>><?php esc_html_e('Euro (EUR)', 'simple-bike-rental'); ?></option>
                        <option value="usd" <?php selected($simpbire_valuta_pagamento, 'usd'); ?>><?php esc_html_e('Dollar USA (USD)', 'simple-bike-rental'); ?></option>
                        <option value="gbp" <?php selected($simpbire_valuta_pagamento, 'gbp'); ?>><?php esc_html_e('Pound Sterling (GBP)', 'simple-bike-rental'); ?></option>
                        <option value="cad" <?php selected($simpbire_valuta_pagamento, 'cad'); ?>><?php esc_html_e('Canadian Dollar (CAD)', 'simple-bike-rental'); ?></option>
                        <option value="aud" <?php selected($simpbire_valuta_pagamento, 'aud'); ?>><?php esc_html_e('Australian Dollar (AUD)', 'simple-bike-rental'); ?></option>
                        <option value="chf" <?php selected($simpbire_valuta_pagamento, 'chf'); ?>><?php esc_html_e('Swiss Franc (CHF)', 'simple-bike-rental'); ?></option>
                        <option value="sek" <?php selected($simpbire_valuta_pagamento, 'sek'); ?>><?php esc_html_e('Swedish Krona (SEK)', 'simple-bike-rental'); ?></option>
                        <option value="dkk" <?php selected($simpbire_valuta_pagamento, 'dkk'); ?>><?php esc_html_e('Danish Krone (DKK)', 'simple-bike-rental'); ?></option>
                        <option value="nok" <?php selected($simpbire_valuta_pagamento, 'nok'); ?>><?php esc_html_e('Norwegian Krone (NOK)', 'simple-bike-rental'); ?></option>
                        <option value="pln" <?php selected($simpbire_valuta_pagamento, 'pln'); ?>><?php esc_html_e('Polish Zloty (PLN)', 'simple-bike-rental'); ?></option>
                        <option value="czk" <?php selected($simpbire_valuta_pagamento, 'czk'); ?>><?php esc_html_e('Czech Koruna (CZK)', 'simple-bike-rental'); ?></option>
                    </select>
                    <p class="description"><?php esc_html_e('Currency used to display rental prices. Matches the Pro version option name for compatibility.', 'simple-bike-rental'); ?></p>
                </td>
            </tr>

            <!-- Email Sender -->
            <tr>
                <th scope="row"><label for="email_nome_mittente"><?php esc_html_e('Sender email name', 'simple-bike-rental'); ?></label></th>
                <td>
                    <input type="text" name="email_nome_mittente" id="email_nome_mittente" class="regular-text" value="<?php echo esc_attr($simpbire_email_nome_mittente); ?>">
                    <p class="description"><?php esc_html_e('Name displayed as the sender in emails sent.', 'simple-bike-rental'); ?></p>
                </td>
            </tr>

            <tr>
                <th scope="row"><label for="email_indirizzo_mittente"><?php esc_html_e('Sender email address', 'simple-bike-rental'); ?></label></th>
                <td>
                    <input type="email" name="email_indirizzo_mittente" id="email_indirizzo_mittente" class="regular-text" value="<?php echo esc_attr($simpbire_email_indirizzo_mittente); ?>">
                    <p class="description"><?php esc_html_e('Use a different email than the admin to prevent notifications from ending up in spam.', 'simple-bike-rental'); ?></p>
                </td>
            </tr>

            <!-- Activate online payment (Pro only) -->
            <tr>
                <th scope="row"><?php esc_html_e('Online payment', 'simple-bike-rental'); ?></th>
                <td>
                <?php
                // translators: %s is the URL to the Simple Bike Rental Pro page.
                $simpbire_scopri_pro = __('Available only in the Pro version. <a href="%s" target="_blank">Find out more</a>.', 'simple-bike-rental');
                echo wp_kses_post(sprintf($simpbire_scopri_pro, esc_url('https://simplebikerental.com')));
                ?>
                </td>
            </tr>

            <!-- Eliminazione tabelle -->
            <tr>
                <th scope="row"><label for="elimina_tabelle_plugin"><?php esc_html_e('Delete tables on uninstall', 'simple-bike-rental'); ?></label></th>
                <td>
                    <input type="checkbox" name="elimina_tabelle_plugin" id="elimina_tabelle_plugin" value="1" <?php checked($simpbire_elimina_tabelle_plugin, 1); ?>>
                    <p class="description"><?php esc_html_e('If enabled, all plugin tables will be deleted when the plugin is uninstalled.', 'simple-bike-rental'); ?></p>
                </td>
            </tr>
        </table>

        <!-- Nonce field for settings form to validate on submission. -->
        <?php wp_nonce_field('salva_impostazioni_noleggio', 'simpbire_nonce'); ?>
        <?php submit_button(esc_html__('Save Settings', 'simple-bike-rental'), 'primary', 'salva_impostazioni'); ?>
    </form>
</div>
