<?php
if ( ! defined( 'ABSPATH' ) ) {
    exit;
}

/**
 * Frontend template of the booking form (shortcode).
 *
 * Note: The hidden nonce field below is included for additional security
 * and compatibility with potential future fallback POST submissions.
 * Even though AJAX currently passes the nonce via wp_localize_script,
 * this field ensures the form remains secure if submitted directly.
 */
$simpbire_frontend_nonce = wp_create_nonce('simpbire_frontend_nonce');
?>
<div id="form-noleggio-frontend" class="noleggio-frontend-wrapper">
    <form id="form-noleggio" action="<?php echo esc_url(admin_url('admin-ajax.php')); ?>" method="POST">
        <!-- Selezione tipo di noleggio -->
        <div class="form-field">
            <label for="tipo_noleggio"><?php esc_html_e('Rental Type', 'simple-bike-rental'); ?></label>
            <select id="tipo_noleggio" name="tipo_noleggio" required>
                <option value=""><?php esc_html_e('— Select —', 'simple-bike-rental'); ?></option>
                <option value="giornaliero"><?php esc_html_e('Daily', 'simple-bike-rental'); ?></option>
                <option value="orario"><?php esc_html_e('Hourly', 'simple-bike-rental'); ?></option>
            </select>
        </div>

        <!-- Campi per il tipo di noleggio -->
        <div id="campo_giornaliero" class="form-field" style="display: none;">
            <label for="data_noleggio"><?php esc_html_e('Date', 'simple-bike-rental'); ?></label>
            <input type="text" id="data_noleggio" name="data_noleggio" class="regular-text">
        </div>

        <div id="campo_orario" class="form-field" style="display: none;">
            <label for="data_inizio_orario"><?php esc_html_e('Start date and time', 'simple-bike-rental'); ?></label>
            <input type="text" id="data_inizio_orario" name="data_inizio_orario" class="regular-text">

            <label for="data_fine_orario" style="margin-top: 10px;"><?php esc_html_e('End date and time', 'simple-bike-rental'); ?></label>
            <input type="text" id="data_fine_orario" name="data_fine_orario" class="regular-text">
        </div>

        <!-- Sezione biciclette disponibili -->
        <div id="sezione-biciclette" style="margin-top: 20px;">
            <h3><?php esc_html_e('Bicycles available', 'simple-bike-rental'); ?></h3>
            <div id="lista-biciclette" class="griglia-biciclette">
                <!-- Le card bici verranno caricate dinamicamente qui -->
            </div>
        </div>

        <!-- Campo nascosto per ID bici selezionata -->
        <input type="hidden" name="bicicletta_id" id="bicicletta_id_selezionata" value="">

        <!-- Nonce per la verifica -->
        <input type="hidden" name="security" value="<?php echo esc_attr($simpbire_frontend_nonce); ?>">

        <!-- Dati utente -->
        <div class="form-field" style="margin-top: 20px;">
            <label for="nome"><?php esc_html_e('Name', 'simple-bike-rental'); ?></label>
            <input type="text" id="nome" name="nome" class="regular-text" required>
        </div>

        <div class="form-field">
            <label for="email"><?php esc_html_e('Email', 'simple-bike-rental'); ?></label>
            <input type="email" id="email" name="email" class="regular-text" required>
        </div>

        <div class="form-field">
            <label for="telefono"><?php esc_html_e('Phone', 'simple-bike-rental'); ?></label>
            <input type="text" id="telefono" name="telefono" class="regular-text">
        </div>

        <!-- Pulsante di invio -->
        <div style="margin-top: 20px;">
            <button type="submit" class="btn-noleggio"><?php esc_html_e('Book now', 'simple-bike-rental'); ?></button>
        </div>

        <div id="messaggio-prenotazione" class="messaggio-prenotazione" style="margin-top:20px; display:none;"></div>
    </form>
</div>
