<?php
if ( ! defined( 'ABSPATH' ) ) {
    exit;
}

/** @var int $id */
/** @var stdClass $bicicletta */
?>

<!-- Modulo di modifica bicicletta nel backend -->
<div class="wrap">
        <h1><?php esc_html_e('Edit Bicycle', 'simple-bike-rental'); ?></h1>

        <form method="post" action="<?php echo esc_url(admin_url('admin-post.php')); ?>">
            <input type="hidden" name="action" value="simpbire_modifica_bicicletta_admin">
            <input type="hidden" name="bicicletta_id" value="<?php echo esc_attr($id); ?>">
            <?php wp_nonce_field('simpbire_modifica_bicicletta', 'simpbire_nonce'); ?>

            <div class="form-field">
                <label for="nome_bicicletta"><?php esc_html_e('Bicycle Name', 'simple-bike-rental'); ?></label>
                <input name="nome_bicicletta" id="nome_bicicletta" type="text" class="regular-text" value="<?php echo esc_attr($bicicletta->nome); ?>" required>
            </div>

            <div class="form-field">
                <label for="descrizione"><?php esc_html_e('Description', 'simple-bike-rental'); ?></label>
                <?php
                wp_editor(
                    $bicicletta->descrizione,
                    'descrizione',
                    [
                        'textarea_name' => 'descrizione',
                        'media_buttons' => false,
                        'teeny' => true,
                        'textarea_rows' => 6,
                        'tinymce' => [
                            'toolbar1' => 'bold,italic,underline,bullist,numlist,link,unlink',
                            'toolbar2' => '',
                        ],
                    ]
                );
                ?>
            </div>

            <div class="form-field">
                <label for="tipo_bicicletta"><?php esc_html_e('Bicycle Type', 'simple-bike-rental'); ?></label>
                <input name="tipo_bicicletta" id="tipo_bicicletta" type="text" class="regular-text" value="<?php echo esc_attr($bicicletta->tipo); ?>" required>
            </div>

            <div class="form-field">
                <label for="tariffa_giornaliera"><?php esc_html_e('Daily Rate', 'simple-bike-rental'); ?></label>
                <input name="tariffa_giornaliera" id="tariffa_giornaliera" type="number" step="0.01" class="regular-text" value="<?php echo esc_attr($bicicletta->tariffa_giornaliera); ?>" required>
            </div>

            <div class="form-field">
                <label for="tariffa_oraria"><?php esc_html_e('Hourly Rate', 'simple-bike-rental'); ?></label>
                <input name="tariffa_oraria" id="tariffa_oraria" type="number" step="0.01" class="regular-text" value="<?php echo esc_attr($bicicletta->tariffa_oraria); ?>" required>
            </div>

            <!-- Gestione immagine -->
            <div class="form-field">
                <label><?php esc_html_e( 'Bicycle Image', 'simple-bike-rental' ); ?></label>
                <div style="margin-bottom: 10px;">
                    <?php
                    $simpbire_immagine_url = '';
                    if ( $bicicletta->immagine ) {
                        $simpbire_immagine_url = wp_get_attachment_image_url( $bicicletta->immagine, 'thumbnail' );
                    }
                    ?>
                    <img
                        id="anteprima_immagine"
                        src="<?php echo esc_url( $simpbire_immagine_url ); ?>"
                        alt="<?php esc_attr_e( 'Bicycle image preview', 'simple-bike-rental' ); ?>"
                        style="max-width: 150px; <?php echo $simpbire_immagine_url ? '' : 'display:none;'; ?>"
                    >
                </div>

                <div style="display: flex; align-items: center; gap: 10px;">
                    <button type="button" class="button" id="upload_image_button">
                        <?php esc_html_e( 'Select Image', 'simple-bike-rental' ); ?>
                    </button>
                    <button
                        type="button"
                        class="button"
                        id="rimuovi_image_button"
                        style="display: <?php echo $simpbire_immagine_url ? 'inline-block' : 'none'; ?>;"
                    >
                        <?php esc_html_e( 'Remove', 'simple-bike-rental' ); ?>
                    </button>
                    <input
                        type="text"
                        id="immagine_nome"
                        class="regular-text"
                        readonly
                        style="border: none; background: transparent; flex: 1; font-style: italic;"
                        value="<?php echo esc_attr( $simpbire_immagine_url ? basename( $simpbire_immagine_url ) : '' ); ?>"
                    >
                </div>

                <input type="hidden" name="immagine_id" id="immagine_id" value="<?php echo esc_attr( $bicicletta->immagine ); ?>">
            </div>

            <div class="form-field">
                <label for="quantita"><?php esc_html_e('Available quantity', 'simple-bike-rental'); ?></label>
                <input name="quantita" id="quantita" type="number" class="regular-text" value="<?php echo esc_attr($bicicletta->quantita); ?>" min="1" required>
            </div>

            <?php submit_button(esc_html__('Save Changes', 'simple-bike-rental')); ?>
        </form>
    </div>
    