<?php
if ( ! defined( 'ABSPATH' ) ) {
    exit;
}
/* @var stdClass $prenotazione */
/* @var array $biciclette */
/* @var string $tipo_noleggio */
?>

<!-- Modulo di modifica prenotazione backend -->
<form method="post" action="<?php echo esc_url(admin_url('admin-post.php')); ?>">
    <input type="hidden" name="action" value="simpbire_modifica_prenotazione_admin">
    <input type="hidden" name="id" value="<?php echo esc_attr($prenotazione->id); ?>">
    <?php wp_nonce_field('simpbire_modifica_prenotazione_admin_action', 'simpbire_modifica_prenotazione_admin_nonce'); ?>

    <div class="form-field">
        <label for="nome"><?php esc_html_e('Name', 'simple-bike-rental'); ?></label>
        <input type="text" name="nome" id="nome" class="regular-text" value="<?php echo esc_attr($prenotazione->nome); ?>" required>
    </div>

    <div class="form-field">
        <label for="email"><?php esc_html_e('Email', 'simple-bike-rental'); ?></label>
        <input type="email" name="email" id="email" class="regular-text" value="<?php echo esc_attr($prenotazione->email); ?>" required>
    </div>

    <div class="form-field">
        <label for="telefono"><?php esc_html_e('Phone', 'simple-bike-rental'); ?></label>
        <input type="text" name="telefono" id="telefono" class="regular-text" value="<?php echo esc_attr($prenotazione->telefono); ?>">
    </div>

    <div class="form-field">
        <label for="tipo_noleggio"><?php esc_html_e('Rental Type', 'simple-bike-rental'); ?></label>
        <select name="tipo_noleggio" id="tipo_noleggio" class="regular-text">
            <option value="giornaliero" <?php selected($tipo_noleggio, 'giornaliero'); ?>>
                <?php esc_html_e('Daily', 'simple-bike-rental'); ?>
            </option>
            <option value="orario" <?php selected($tipo_noleggio, 'orario'); ?>>
                <?php esc_html_e('Hourly', 'simple-bike-rental'); ?>
            </option>
        </select>
    </div>

    <div id="row_data_giornaliera" class="form-field" style="display: none;">
        <label for="data_giornaliera"><?php esc_html_e('Date (Daily)', 'simple-bike-rental'); ?></label>
        <div class="datepicker-wrapper">
            <input type="text" name="data_giornaliera" id="data_giornaliera" class="regular-text" value="<?php echo esc_attr(substr($prenotazione->data_inizio, 0, 10)); ?>">
            <span class="dashicons dashicons-calendar calendar-icon" data-target="data_giornaliera"></span>
        </div>
    </div>

    <div id="row_data_oraria" class="form-field" style="display: none;">
        <label for="data_inizio"><?php esc_html_e('Start date and time', 'simple-bike-rental'); ?></label>
        <div class="datepicker-wrapper">
            <input type="text" name="data_inizio" id="data_inizio" class="regular-text" value="<?php echo esc_attr($prenotazione->data_inizio); ?>">
            <span class="dashicons dashicons-calendar calendar-icon" data-target="data_inizio"></span>
        </div>
    </div>

    <div id="row_data_fine" class="form-field" style="display: none;">
        <label for="data_fine"><?php esc_html_e('End date and time', 'simple-bike-rental'); ?></label>
        <div class="datepicker-wrapper">
            <input type="text" name="data_fine" id="data_fine" class="regular-text" value="<?php echo esc_attr($prenotazione->data_fine); ?>">
            <span class="dashicons dashicons-calendar calendar-icon" data-target="data_fine"></span>
        </div>
    </div>

    <div class="form-field">
        <label for="bicicletta_id"><?php esc_html_e( 'Bicycle', 'simple-bike-rental' ); ?></label>
        <select name="bicicletta_id" id="bicicletta_id" class="regular-text">
            <?php foreach ( $biciclette as $simpbire_bici ) : ?>
                <option value="<?php echo esc_attr( $simpbire_bici->id ); ?>" <?php selected( $prenotazione->bicicletta_id, $simpbire_bici->id ); ?>>
                    <?php echo esc_html( $simpbire_bici->nome ); ?>
                </option>
            <?php endforeach; ?>
        </select>
    </div>

    <?php submit_button(esc_html__('Save changes', 'simple-bike-rental')); ?>
</form>
