<?php
if ( ! defined( 'ABSPATH' ) ) {
    exit;
}
/* @var string $slug */
/* @var array $notifica */
/* @var string $attiva */
/* @var string $oggetto */
/* @var string $contenuto */
/* @var string $destinatari_valore */
?>

<!-- Modulo per la modifica delle impostazioni di una notifica email -->
<form method="post" action="<?php echo esc_url(admin_url('admin-post.php')); ?>">
    <input type="hidden" name="action" value="simpbire_salva_notifica_admin">
    <input type="hidden" name="notifica_slug" value="<?php echo esc_attr($slug); ?>">
    <table class="form-table">
        <tr>
            <th scope="row"><label for="attiva_notifica"><?php esc_html_e('Active', 'simple-bike-rental'); ?></label></th>
            <td>
                <input type="checkbox" id="attiva_notifica" name="attiva_notifica" <?php checked($attiva, 1); ?>>
                <?php esc_html_e('Enable this notification', 'simple-bike-rental'); ?>
            </td>
        </tr>
        <tr>
            <th scope="row"><label for="oggetto_email"><?php esc_html_e('Subject', 'simple-bike-rental'); ?></label></th>
            <td><input type="text" name="oggetto_email" id="oggetto_email" class="regular-text" value="<?php echo esc_attr($oggetto); ?>"></td>
        </tr>
        <?php if ($notifica['destinatario'] === 'custom') : ?>
        <tr>
            <th scope="row"><label for="destinatari_email"><?php esc_html_e('Recipients', 'simple-bike-rental'); ?></label></th>
            <td>
                <input type="text" name="destinatari_email" id="destinatari_email" value="<?php echo esc_attr($destinatari_valore); ?>" class="regular-text">
                <p class="description"><?php esc_html_e('Enter one or more email addresses, separated by commas.', 'simple-bike-rental'); ?></p>
            </td>
        </tr>
        <?php endif; ?>
        <tr>
            <th scope="row"><label for="corpo_email"><?php esc_html_e('Content', 'simple-bike-rental'); ?></label></th>
            <td>
                <?php
                wp_editor($contenuto, 'corpo_email', [
                    'textarea_name' => 'corpo_email',
                    'media_buttons' => false,
                    'teeny' => true,
                    'textarea_rows' => 10,
                    'tinymce' => [
                        'toolbar1' => 'bold,italic,underline,link,unlink,bullist,numlist',
                        'toolbar2' => '',
                    ],
                ]);
                ?>
                <p class="description" style="margin:10px 5px;"><?php esc_html_e('You can use the following placeholders:', 'simple-bike-rental'); ?></p>
                <code><?php echo implode('</code>, <code>', array_map('esc_html', $notifica['segnaposto'])); ?></code>
            </td>
        </tr>
    </table>

    <?php wp_nonce_field('simpbire_salva_notifica_nonce', 'simpbire_salva_notifica_nonce_field'); ?>
    <?php submit_button(esc_html__('Save Notification', 'simple-bike-rental'), 'primary', 'salva_notifica'); ?>
</form>
