<?php
if ( ! defined( 'ABSPATH' ) ) {
    exit;
}
?>
<!-- Template: Aggiungi Prenotazione (admin) -->
<form method="post" action="<?php echo esc_url(admin_url('admin-post.php')); ?>">
    <input type="hidden" name="action" value="simpbire_aggiungi_prenotazione_admin">
    <?php wp_nonce_field('simpbire_aggiungi_prenotazione_admin_action', 'simpbire_aggiungi_prenotazione_admin_nonce'); ?>

    <div class="form-field">
        <label for="nome_utente"><?php esc_html_e('Name', 'simple-bike-rental'); ?></label>
        <input type="text" id="nome_utente" name="nome_utente" class="regular-text" required>
    </div>

    <div class="form-field">
        <label for="email_utente"><?php esc_html_e('Email', 'simple-bike-rental'); ?></label>
        <input type="email" id="email_utente" name="email_utente" class="regular-text" required>
    </div>

    <div class="form-field">
        <label for="telefono_utente"><?php esc_html_e('Phone', 'simple-bike-rental'); ?></label>
        <input type="text" id="telefono_utente" name="telefono_utente" class="regular-text">
    </div>

    <div class="form-field">
        <label for="tipo_noleggio"><?php esc_html_e('Rental Type', 'simple-bike-rental'); ?></label>
        <select name="tipo_noleggio" id="tipo_noleggio" class="regular-text" required>
            <option value=""><?php esc_html_e('— Select —', 'simple-bike-rental'); ?></option>
            <option value="giornaliero"><?php esc_html_e('Daily', 'simple-bike-rental'); ?></option>
            <option value="orario"><?php esc_html_e('Hourly', 'simple-bike-rental'); ?></option>
        </select>
    </div>

    <!-- Campo Giornaliero -->
    <div id="campo_data_giornaliera" class="form-field" style="display: none;">
        <label for="data_giornaliera"><?php esc_html_e('Date (Daily)', 'simple-bike-rental'); ?></label>
        <div class="datepicker-wrapper">
            <input type="text" id="data_giornaliera" name="data_giornaliera" class="regular-text">
            <span class="dashicons dashicons-calendar calendar-icon" data-target="data_giornaliera"></span>
        </div>
    </div>

    <!-- Campo Orario -->
    <div id="campo_data_oraria" class="form-field" style="display: none;">
        <label for="data_inizio_oraria"><?php esc_html_e('Start Date and Time', 'simple-bike-rental'); ?></label>
        <div class="datepicker-wrapper">
            <input type="text" id="data_inizio_oraria" name="data_inizio_oraria" class="regular-text">
            <span class="dashicons dashicons-calendar calendar-icon" data-target="data_inizio_oraria"></span>
        </div>
        &nbsp;
        <label for="data_fine_oraria"><?php esc_html_e('End Date and Time', 'simple-bike-rental'); ?></label>
        <div class="datepicker-wrapper">
            <input type="text" id="data_fine_oraria" name="data_fine_oraria" class="regular-text">
            <span class="dashicons dashicons-calendar calendar-icon" data-target="data_fine_oraria"></span>
        </div>
    </div>

    <div class="form-field">
        <label for="bicicletta_id"><?php esc_html_e('Bicycle', 'simple-bike-rental'); ?></label>
        <select name="bicicletta_id" id="bicicletta_id" class="regular-text" disabled>
            <option value=""><?php esc_html_e('Please select a date before...', 'simple-bike-rental'); ?></option>
        </select>
    </div>

    <?php submit_button(esc_html__('Save Booking', 'simple-bike-rental')); ?>
</form>
