<?php
if ( ! defined( 'ABSPATH' ) ) {
    exit;
}

/**
 * Export Reservations Template
 * Path: templates/admin/esporta-prenotazioni.php
 */
?>
<div class="wrap">
  <h1><?php esc_html_e('Export Reservations', 'simple-bike-rental'); ?></h1>
  <p><?php esc_html_e('Use the filters below to export reservations into a CSV file.', 'simple-bike-rental'); ?></p>

  <form method="get" action="">
    <?php wp_nonce_field( 'simpbire_export_csv_action', 'simpbire_export_csv_nonce' ); ?>
    <input type="hidden" name="page" value="esporta_prenotazioni">
    <input type="hidden" name="export_csv" value="1">

    <table class="form-table">
      <tr>
        <th><label for="stato"><?php esc_html_e('Status', 'simple-bike-rental'); ?></label></th>
        <td>
          <select name="stato" id="stato">
            <option value=""><?php esc_html_e('All', 'simple-bike-rental'); ?></option>
            <option value="active"><?php esc_html_e('Active', 'simple-bike-rental'); ?></option>
            <option value="completed"><?php esc_html_e('Completed', 'simple-bike-rental'); ?></option>
            <option value="pending"><?php esc_html_e('Pending', 'simple-bike-rental'); ?></option>
            <option value="cancelled"><?php esc_html_e('Cancelled', 'simple-bike-rental'); ?></option>
          </select>
        </td>
      </tr>
      <tr>
        <th><label for="tipo"><?php esc_html_e('Rental Type', 'simple-bike-rental'); ?></label></th>
        <td>
          <select name="tipo" id="tipo">
            <option value=""><?php esc_html_e('All', 'simple-bike-rental'); ?></option>
            <option value="daily"><?php esc_html_e('Daily', 'simple-bike-rental'); ?></option>
            <option value="hourly"><?php esc_html_e('Hourly', 'simple-bike-rental'); ?></option>
          </select>
        </td>
      </tr>
      <tr>
        <th><label for="data_da"><?php esc_html_e('From Date', 'simple-bike-rental'); ?></label></th>
        <td>
          <div class="datepicker-wrapper">
            <input type="text" name="data_da" id="data_da" class="regular-text flatpickr" placeholder="YYYY-MM-DD">
            <span class="dashicons dashicons-calendar calendar-icon" data-target="data_da"></span>
          </div>
          <p class="description"><?php esc_html_e('Leave empty to include all dates.', 'simple-bike-rental'); ?></p>
        </td>
      </tr>
      <tr>
        <th><label for="data_a"><?php esc_html_e('To Date', 'simple-bike-rental'); ?></label></th>
        <td>
          <div class="datepicker-wrapper">
            <input type="text" name="data_a" id="data_a" class="regular-text flatpickr" placeholder="YYYY-MM-DD">
            <span class="dashicons dashicons-calendar calendar-icon" data-target="data_a"></span>
          </div>
          <p class="description"><?php esc_html_e('Leave empty to include all dates.', 'simple-bike-rental'); ?></p>
        </td>
      </tr>
    </table>

    <p>
      <button type="submit" class="button button-primary">
        <?php esc_html_e('Export CSV', 'simple-bike-rental'); ?>
      </button>
    </p>
  </form>
</div>
