<?php
if ( ! defined( 'ABSPATH' ) ) {
    exit;
}

/* @var array $biciclette */
?>
<div class="wrap">
    <h1><?php esc_html_e('Bicycle Management', 'simple-bike-rental'); ?></h1>

    <?php simpbire_mostra_messaggi('bicicletta'); ?>

    <p>
        <a href="<?php echo esc_url(admin_url('admin.php?page=aggiungi_biciclette')); ?>" class="button button-primary">
            <?php esc_html_e('Add New Bike', 'simple-bike-rental'); ?>
        </a>
    </p>

    <h2><?php esc_html_e('Bicycle List', 'simple-bike-rental'); ?></h2>

    <?php if ($biciclette) : ?>
        <table class="widefat fixed">
            <thead>
                <tr>
                    <th class="bicicletta-id"><?php esc_html_e('ID', 'simple-bike-rental'); ?></th>
                    <th class="bicicletta-img"><?php esc_html_e('Image', 'simple-bike-rental'); ?></th>
                    <th><?php esc_html_e('Name', 'simple-bike-rental'); ?></th>
                    <th><?php esc_html_e('Type', 'simple-bike-rental'); ?></th>
                    <th><?php esc_html_e('Quantity', 'simple-bike-rental'); ?></th>
                    <th><?php esc_html_e('Daily Rate', 'simple-bike-rental'); ?></th>
                    <th><?php esc_html_e('Hourly Rate', 'simple-bike-rental'); ?></th>
                    <th><?php esc_html_e('Actions', 'simple-bike-rental'); ?></th>
                </tr>
            </thead>
            <tbody>
                <?php foreach ( $biciclette as $simpbire_bicicletta ) :
                    $simpbire_immagine_id   = $simpbire_bicicletta->immagine;
                    $simpbire_immagine_html = $simpbire_immagine_id
                        ? '<img src="' . esc_url( wp_get_attachment_image_url( $simpbire_immagine_id, 'thumbnail' ) ) . '" alt="' . esc_attr( $simpbire_bicicletta->nome ) . '" width="50" height="50">'
                        : esc_html__( 'No image', 'simple-bike-rental' );

                    $simpbire_nonce_modifica = wp_create_nonce( 'simpbire_modifica_bicicletta_' . $simpbire_bicicletta->id );
                    $simpbire_url_modifica   = add_query_arg(
                        array(
                            'page'     => 'modifica_bicicletta',
                            'id'       => (int) $simpbire_bicicletta->id,
                            '_wpnonce' => $simpbire_nonce_modifica,
                        ),
                        admin_url( 'admin.php' )
                    );
                ?>
                    <tr>
                        <td class="cell-center"><?php echo esc_html( $simpbire_bicicletta->id ); ?></td>
                        <td>
                            <?php
                            echo wp_kses(
                                $simpbire_immagine_html,
                                array(
                                    'img' => array(
                                        'src'    => true,
                                        'alt'    => true,
                                        'width'  => true,
                                        'height' => true,
                                    ),
                                )
                            );
                            ?>
                        </td>
                        <td><?php echo esc_html( $simpbire_bicicletta->nome ); ?></td>
                        <td><?php echo esc_html( $simpbire_bicicletta->tipo ); ?></td>
                        <td><?php echo (int) $simpbire_bicicletta->quantita; ?></td>
                        <td><?php echo esc_html( $simpbire_bicicletta->tariffa_giornaliera ); ?></td>
                        <td><?php echo esc_html( $simpbire_bicicletta->tariffa_oraria ); ?></td>
                        <td>
                            <div class="noleggio-icone-wrapper">
                                <a href="<?php echo esc_url( $simpbire_url_modifica ); ?>" class="noleggio-icona-btn modifica" title="<?php esc_attr_e( 'Edit', 'simple-bike-rental' ); ?>">
                                    <span class="dashicons dashicons-edit"></span>
                                </a>
                                <form method="post" action="<?php echo esc_url( admin_url( 'admin-post.php' ) ); ?>" style="display:inline;" onsubmit="return confirm('<?php echo esc_js( __( 'Are you sure you want to delete this bike?', 'simple-bike-rental' ) ); ?>');">
                                    <input type="hidden" name="action" value="simpbire_elimina_bicicletta_admin">
                                    <input type="hidden" name="id" value="<?php echo esc_attr( $simpbire_bicicletta->id ); ?>">
                                    <?php wp_nonce_field( 'simpbire_elimina_bicicletta_' . $simpbire_bicicletta->id, 'simpbire_elimina_bicicletta_nonce' ); ?>
                                    <button type="submit" class="noleggio-icona-btn elimina" title="<?php esc_attr_e( 'Delete', 'simple-bike-rental' ); ?>">
                                        <span class="dashicons dashicons-trash"></span>
                                    </button>
                                </form>
                            </div>
                        </td>
                    </tr>
                <?php endforeach; ?>
            </tbody>
        </table>
    <?php else : ?>
        <p><?php esc_html_e('No bicycles available.', 'simple-bike-rental'); ?></p>
    <?php endif; ?>
</div>
