<?php
if ( ! defined( 'ABSPATH' ) ) {
    exit;
}
?>
<div class="wrap">
        <h1><?php esc_html_e('Add New Bike', 'simple-bike-rental'); ?></h1>

        <form method="post" action="<?php echo esc_url(admin_url('admin-post.php')); ?>">
            <input type="hidden" name="action" value="simpbire_aggiungi_bicicletta_admin">

            <div class="form-field">
                <label for="nome_bicicletta"><?php esc_html_e('Bicycle Name', 'simple-bike-rental'); ?></label>
                <input name="nome_bicicletta" id="nome_bicicletta" type="text" class="regular-text" required>
            </div>

            <div class="form-field">
                <label for="descrizione"><?php esc_html_e('Description', 'simple-bike-rental'); ?></label>
                <?php
                wp_editor('', 'descrizione', [
                    'textarea_name' => 'descrizione',
                    'media_buttons' => false,
                    'teeny' => true,
                    'textarea_rows' => 6,
                    'tinymce' => [
                        'toolbar1' => 'bold,italic,underline,bullist,numlist,link,unlink',
                        'toolbar2' => '',
                    ],
                ]);
                ?>
            </div>

            <div class="form-field">
                <label for="tipo_bicicletta"><?php esc_html_e('Bicycle Type', 'simple-bike-rental'); ?></label>
                <input name="tipo_bicicletta" id="tipo_bicicletta" type="text" class="regular-text" required>
            </div>

            <div class="form-field">
                <label for="tariffa_giornaliera"><?php esc_html_e('Daily Rate', 'simple-bike-rental'); ?></label>
                <input name="tariffa_giornaliera" id="tariffa_giornaliera" type="number" class="regular-text" step="0.01" required>
            </div>

            <div class="form-field">
                <label for="tariffa_oraria"><?php esc_html_e('Hourly Rate', 'simple-bike-rental'); ?></label>
                <input name="tariffa_oraria" id="tariffa_oraria" type="number" class="regular-text" step="0.01" required>
            </div>

            <div class="form-field">
                <label for="immagine"><?php esc_html_e('Bicycle Image', 'simple-bike-rental'); ?></label>
                <div style="display: flex; align-items: center; gap: 10px;">
                    <button type="button" class="button" id="upload_image_button"><?php esc_html_e('Select Image', 'simple-bike-rental'); ?></button>
                    <input type="text" name="immagine" id="immagine" class="regular-text" readonly style="flex: 1; border:none; color:#333333; font-style:italic;">
                </div>
                <input type="hidden" name="immagine_id" id="immagine_id" value="">
            </div>

            <div class="form-field">
                <label for="quantita"><?php esc_html_e('Available quantity', 'simple-bike-rental'); ?></label>
                <input name="quantita" id="quantita" type="number" class="regular-text" value="1" min="1" required>
            </div>

            <?php wp_nonce_field('simpbire_aggiungi_bicicletta', 'simpbire_nonce'); ?>
            <?php submit_button(esc_html__('Add a bicycle', 'simple-bike-rental')); ?>
        </form>
    </div>