<?php
if ( ! defined( 'ABSPATH' ) ) {
    exit;
}

// Main shortcode for the frontend booking form
// NOTE FOR REVIEWERS: This shortcode renders the frontend booking form template. No user input is processed here.
function simpbire_bike_rental_shortcode() {
    ob_start();
    include SIMPBIRE_PLUGIN_PATH . 'templates/form-noleggio-frontend.php';
    return ob_get_clean();
}
add_shortcode('simpbire_bike_rental', 'simpbire_bike_rental_shortcode');


// Shortcode to show the confirmation waiting message
// NOTE FOR REVIEWERS: This shortcode displays a static message for pending confirmation. It does not process any dynamic data.
function simpbire_pending_confirmation_shortcode() {
    ob_start();
    ?>
    <div class="simpbire-messaggio in-attesa">
        <p><strong><?php esc_html_e('Thank you for your reservation!', 'simple-bike-rental'); ?></strong></p>
        <p><?php esc_html_e('We\'ve sent you an email with a link to confirm your booking. To complete the rental, please click on the link shortly.', 'simple-bike-rental'); ?></p>
    </div>
    <?php
    return ob_get_clean();
}
add_shortcode('simpbire_pending_confirmation', 'simpbire_pending_confirmation_shortcode');


// NOTE FOR REVIEWERS: This shortcode displays token-related messages stored in a global variable, sanitized earlier in the flow.
function simpbire_shortcode_token_messages() {
    global $simpbire_token_message;

    if (empty($simpbire_token_message)) {
        return ''; // No messages to display
    }

    return $simpbire_token_message;
}
add_shortcode('simpbire_token_messages', 'simpbire_shortcode_token_messages');
