document.addEventListener('DOMContentLoaded', function () {
    // === BOOKING FORM FIELDS (frontend) ===
    const tipoNoleggio = document.getElementById('tipo_noleggio');
    const campoGiornaliero = document.getElementById('campo_giornaliero');
    const campoOrario = document.getElementById('campo_orario');
    const contenitoreBici = document.getElementById('lista-biciclette');
    const campoIdBici = document.getElementById('bicicletta_id_selezionata');
    const inputData = document.getElementById('data_noleggio');
    const dataInizioOrario = document.getElementById('data_inizio_orario');
    const dataFineOrario = document.getElementById('data_fine_orario');

    // === Change the visibility of rental fields ===
    if (tipoNoleggio && campoGiornaliero && campoOrario) {
        tipoNoleggio.addEventListener('change', function () {
            const valore = tipoNoleggio.value;
            campoGiornaliero.style.display = valore === 'giornaliero' ? '' : 'none';
            campoOrario.style.display = valore === 'orario' ? '' : 'none';

            if (campoIdBici && contenitoreBici) {
                campoIdBici.value = '';
                contenitoreBici.innerHTML = '';
            }
        });
    }

    // === Flatpickr Daily ===
    if (inputData) {
        flatpickr(inputData, {
            dateFormat: "Y-m-d",
            minDate: "today",
            disableMobile: true,
            onClose: function () {
                if (inputData.value) {
                    caricaBicicletteDisponibili('giornaliero', inputData.value + ' 00:00:00', inputData.value + ' 23:59:59');
                }
            }
        });
    }

    // === Flatpickr timetable ===
    if (dataInizioOrario && dataFineOrario) {
        flatpickr(dataInizioOrario, {
            enableTime: true,
            dateFormat: "Y-m-d H:i",
            time_24hr: true,
            minDate: "today",
            disableMobile: true,
            onClose: () => {
                if (dataInizioOrario.value && dataFineOrario.value) {
                    caricaBicicletteDisponibili('orario', dataInizioOrario.value, dataFineOrario.value);
                }
            }
        });

        flatpickr(dataFineOrario, {
            enableTime: true,
            dateFormat: "Y-m-d H:i",
            time_24hr: true,
            minDate: "today",
            disableMobile: true,
            onClose: () => {
                if (dataInizioOrario.value && dataFineOrario.value) {
                    caricaBicicletteDisponibili('orario', dataInizioOrario.value, dataFineOrario.value);
                }
            }
        });
    }

    // === Bike loading available ===
    function caricaBicicletteDisponibili(tipo, inizio, fine) {
        if (!contenitoreBici || !campoIdBici) return;

        contenitoreBici.innerHTML = `<p>${SIMPBIREFrontend.i18n.caricamento}</p>`;
        campoIdBici.value = '';

        const url = `${SIMPBIREFrontend.ajaxurl}?action=simpbire_get_biciclette_disponibili&tipo=${encodeURIComponent(tipo)}&inizio=${encodeURIComponent(inizio)}&fine=${encodeURIComponent(fine)}&security=${SIMPBIREFrontend.nonce_disponibili}`;

        fetch(url)
            .then(response => response.json())
            .then(data => {
                contenitoreBici.innerHTML = '';

                if (data.success && data.data.length > 0) {
                    data.data.forEach(bici => {
                        const card = document.createElement('div');
                        card.className = 'card-bici';
                        card.dataset.id = bici.id;

                        if (bici.immagine) {
                            const img = document.createElement('img');
                            img.src = bici.immagine;
                            img.alt = bici.nome;
                            card.appendChild(img);
                        }

                        // Container for type + name
                        const infoContainer = document.createElement('div');
                        infoContainer.className = 'info-bici';

                        const descrizione = document.createElement('span');
                        descrizione.className = 'info-bici-testo';
                        descrizione.textContent = bici.tipo ? `${bici.tipo} - ${bici.nome}` : bici.nome;

                        infoContainer.appendChild(descrizione);

                        if (bici.etichetta_prezzo) {
                            const prezzo = document.createElement('span');
                            prezzo.className = 'prezzo-bici';
                            prezzo.textContent = bici.etichetta_prezzo;
                            infoContainer.appendChild(prezzo);
                        }
                        card.appendChild(infoContainer);

                        card.addEventListener('click', function () {
                            document.querySelectorAll('.card-bici').forEach(el => el.classList.remove('selezionata'));
                            card.classList.add('selezionata');
                            campoIdBici.value = bici.id;
                        });

                        contenitoreBici.appendChild(card);
                    });
                } else {
                    contenitoreBici.innerHTML = `<p>${SIMPBIREFrontend.i18n.nessuna_bici}</p>`;
                }
            })
            .catch(err => {
                console.error(err);
                contenitoreBici.innerHTML = `<p>${SIMPBIREFrontend.i18n.errore_bici}</p>`;
            });
    }



    // === Send reservation via AJAX ===
    const form = document.getElementById('form-noleggio');
    if (form) {
        form.addEventListener('submit', function (e) {
            e.preventDefault();

            const formData = new FormData(form);
            formData.append('action', 'simpbire_salva_prenotazione_frontend');
            formData.append('security', SIMPBIREFrontend.nonce);

            fetch(form.action, {
                method: 'POST',
                body: formData,
            })
            .then(response => response.json())
            .then(data => {
                const boxMessaggio = document.getElementById('messaggio-prenotazione');
                const redirectUrl = data.data && data.data.redirect_url;
                const message = data.data && data.data.message;

                if (boxMessaggio) {
                    boxMessaggio.style.display = 'block';
                    boxMessaggio.className = 'messaggio-prenotazione ' + (data.success ? 'success' : 'error');
                    boxMessaggio.textContent = message || (data.success ? SIMPBIREFrontend.i18n.prenotazione_ok : SIMPBIREFrontend.i18n.prenotazione_errore);
                }

                if (data.success) {
                    if (redirectUrl) {
                        setTimeout(() => {
                            window.location.href = redirectUrl;
                        }, 1500);
                    } else {
                        form.reset();
                        contenitoreBici.innerHTML = '';
                        campoIdBici.value = '';
                    }
                }
            })
            .catch(error => {
                console.error('Errore AJAX:', error);
                alert(SIMPBIREFrontend.i18n.errore_tecnico);
            });
        });
    }
});
