document.addEventListener('DOMContentLoaded', function() {
    var calendarEl = document.getElementById('calendar');

    if (calendarEl) {
        var calendar = new FullCalendar.Calendar(calendarEl, {
            initialView: 'dayGridMonth',
            locale: CalendarAjax.locale,
            timeZone: 'local',
            height: 700,
            headerToolbar: {
                left: 'prev,next today',
                center: 'title',
                right: 'dayGridMonth,timeGridDay'
            },
            displayEventTime: false,
            events: {
                url: CalendarAjax.ajaxurl + '?action=simpbire_carica_prenotazioni&security=' + encodeURIComponent(CalendarAjax.security),
                method: 'GET',
                failure: function() {
                    alert('Errore nel caricamento delle prenotazioni!');
                }
            },

            eventDidMount: function(info) {
                info.el.setAttribute('title', info.event.title);
            },

            eventClick: function(info) {
                info.jsEvent.preventDefault();

                const dati = info.event.extendedProps;

                document.getElementById('modale-titolo').textContent = info.event.title;
                document.getElementById('modale-email').textContent = dati.email || '—';
                document.getElementById('modale-telefono').textContent = dati.telefono || '—';
                document.getElementById('modale-periodo').textContent = dati.periodo || '—';
                document.getElementById('modale-link-edit').href =
                    dati.link_modifica + '&_wpnonce=' + encodeURIComponent(CalendarAjax.nonce_modifica);

                document.getElementById('modale-bici-nome').textContent = dati.nome_bicicletta || '—';

                const img = document.getElementById('modale-bici-img');
                if (dati.immagine_bicicletta) {
                    img.src = dati.immagine_bicicletta;
                    img.style.display = 'block';
                } else {
                    img.src = '';
                    img.style.display = 'none';
                }

                // Salva ID della prenotazione per eliminazione
                document.getElementById('elimina-prenotazione-btn').dataset.id = info.event.id;

                document.getElementById('modale-prenotazione').style.display = 'block';
            }
        });

        calendar.render();

        document.getElementById('chiudi-modale').addEventListener('click', function () {
            document.getElementById('modale-prenotazione').style.display = 'none';
        });

        document.getElementById('elimina-prenotazione-btn').addEventListener('click', function () {
            const conferma = confirm(CalendarAjax.i18n.conferma_eliminazione);
            if (!conferma) return;

            const prenotazioneId = this.dataset.id;

            fetch(CalendarAjax.ajaxurl, {
                method: 'POST',
                headers: {
                    'Content-Type': 'application/x-www-form-urlencoded',
                },
                body: new URLSearchParams({
                    action: 'simpbire_elimina_prenotazione',
                    id: prenotazioneId,
                    _ajax_nonce: CalendarAjax.nonce
                })
            })
            .then(response => response.json())
            .then(data => {
                if (data.success) {
                    document.getElementById('modale-prenotazione').style.display = 'none';
                    calendar.refetchEvents(); // Ricarica eventi
                } else {
                    alert("Errore: " + (data.data || CalendarAjax.i18n.errore_eliminazione));
                }
            })
            .catch(error => {
                alert(CalendarAjax.i18n.errore_generico);
                console.error(error);
            });
        });
    }

    // Gestione del form frontend (invio via AJAX)
    const form = document.getElementById('form-noleggio');
    if (form) {
        form.addEventListener('submit', function (e) {
            e.preventDefault();

            const formData = new FormData(form);
            formData.append('action', 'simpbire_salva_prenotazione_frontend');

            fetch(form.action, {
                method: 'POST',
                body: formData,
            })
            .then(response => response.json())
            .then(data => {
                if (data.success) {
                    alert('Prenotazione effettuata con successo!');
                    form.reset();
                } else {
                    alert('Errore: ' + (data.message || 'Prenotazione non riuscita'));
                }
            })
            .catch(error => {
                console.error('Errore AJAX:', error);
                alert('Errore nella comunicazione con il server.');
            });
        });
    }
});
