document.addEventListener('DOMContentLoaded', function () {
    const tipoNoleggio = document.getElementById('tipo_noleggio');
    const rowGiornaliero = document.getElementById('row_data_giornaliera');
    const rowOraria = document.getElementById('row_data_oraria');
    const rowFine = document.getElementById('row_data_fine');

    const dataGiornaliera = document.getElementById('data_giornaliera');
    const dataInizio = document.getElementById('data_inizio');
    const dataFine = document.getElementById('data_fine');
    const selectBicicletta = document.getElementById('bicicletta_id');

    function aggiornaVisibilita() {
        const tipo = tipoNoleggio.value;
        rowGiornaliero.style.display = tipo === 'giornaliero' ? '' : 'none';
        rowOraria.style.display = tipo === 'orario' ? '' : 'none';
        rowFine.style.display = tipo === 'orario' ? '' : 'none';
    }

    tipoNoleggio.addEventListener('change', aggiornaVisibilita);
    aggiornaVisibilita();

    function aggiornaBicicletteDisponibili(inizio, fine) {
        if (!inizio || !fine) return;

        selectBicicletta.innerHTML = `<option value="">${simpbireModificaPrenotazioneVars.i18n.caricamento}</option>`;
        selectBicicletta.disabled = true;

        fetch(`${simpbireModificaPrenotazioneVars.ajaxurl}?action=simpbire_get_biciclette_disponibili&inizio=${encodeURIComponent(inizio)}&fine=${encodeURIComponent(fine)}&id_prenotazione=${simpbireModificaPrenotazioneVars.prenotazione_id}&security=${simpbireModificaPrenotazioneVars.nonce}`)
            .then(response => response.json())
            .then(data => {
                selectBicicletta.innerHTML = '';
                if (data.success && data.data.length > 0) {
                    data.data.forEach(bici => {
                        const option = document.createElement('option');
                        option.value = bici.id;
                        option.textContent = bici.nome;
                        if (option.value === String(simpbireModificaPrenotazioneVars.bicicletta_id)) {
                            option.selected = true;
                        }
                        selectBicicletta.appendChild(option);
                    });
                    selectBicicletta.disabled = false;
                } else {
                    const opt = document.createElement('option');
                    opt.value = '';
                    opt.textContent = simpbireModificaPrenotazioneVars.i18n.nessuna_bici;
                    selectBicicletta.appendChild(opt);
                }
            });
    }

    flatpickr(dataGiornaliera, {
        dateFormat: "Y-m-d",
        disableMobile: true,
        onClose: function () {
            setTimeout(() => {
                const data = dataGiornaliera.value;
                if (data) {
                    aggiornaBicicletteDisponibili(data + ' 00:00:00', data + ' 23:59:59');
                }
            }, 100);
        }
    });

    flatpickr(dataInizio, {
        enableTime: true,
        dateFormat: "Y-m-d H:i",
        time_24hr: true,
        disableMobile: true,
        onClose: function () {
            if (dataInizio.value && dataFine.value) {
                aggiornaBicicletteDisponibili(dataInizio.value, dataFine.value);
            }
        }
    });

    flatpickr(dataFine, {
        enableTime: true,
        dateFormat: "Y-m-d H:i",
        time_24hr: true,
        disableMobile: true,
        onClose: function () {
            if (dataInizio.value && dataFine.value) {
                aggiornaBicicletteDisponibili(dataInizio.value, dataFine.value);
            }
        }
    });
});
