document.addEventListener('DOMContentLoaded', function () {
  if (typeof flatpickr !== 'undefined') {
    // Inizializza tutti i campi .flatpickr e salva le istanze
    const instances = {};

    document.querySelectorAll('.flatpickr').forEach(function (input) {
      const fp = flatpickr(input, {
        dateFormat: 'Y-m-d'
      });

      // Salva l'istanza per riaprirla con l'icona
      if (input.id) {
        instances[input.id] = fp;
      }
    });

    // Attiva il calendario quando si clicca sull'icona
    document.querySelectorAll('.calendar-icon').forEach(function (icon) {
      icon.addEventListener('click', function () {
        const targetId = this.getAttribute('data-target');
        if (targetId && instances[targetId]) {
          instances[targetId].open();
        }
      });
    });
  }
});
