function aggiornaBicicletteDisponibili(inizio, fine) {
    if (!inizio || !fine) {
        console.warn('Date non valide per il controllo biciclette:', { inizio, fine });
        return;
    }

    const select = document.getElementById('bicicletta_id');
    select.innerHTML = '<option value="">Caricamento...</option>';
    select.disabled = true;

    fetch(`${simpbireAggiungiPrenotazioneVars.ajaxurl}?action=simpbire_get_biciclette_disponibili&inizio=${encodeURIComponent(inizio)}&fine=${encodeURIComponent(fine)}&security=${simpbireAggiungiPrenotazioneVars.nonce}`)
    .then(response => response.json())
    .then(data => {
        select.innerHTML = '';
    if (data.success && data.data.length > 0) {
        data.data.forEach(bici => {
            const option = document.createElement('option');
            option.value = bici.id;
            option.textContent = bici.nome;
            select.appendChild(option);
        });
        select.disabled = false;
    } else {
        const opt = document.createElement('option');
        opt.value = '';
    opt.textContent = 'Nessuna bici disponibile';
    select.appendChild(opt);
    }
    });
}

document.addEventListener('DOMContentLoaded', function () {
    const tipoNoleggio = document.getElementById('tipo_noleggio');
    const campoGiornaliero = document.getElementById('campo_data_giornaliera');
    const campoOrario = document.getElementById('campo_data_oraria');
    const campoBicicletta = document.getElementById('bicicletta_id');
    const dataGiornaliera = document.getElementById('data_giornaliera');
    const dataInizioOraria = document.getElementById('data_inizio_oraria');
    const dataFineOraria = document.getElementById('data_fine_oraria');

    flatpickr(dataGiornaliera, {
        dateFormat: "Y-m-d",
        disableMobile: true,
        onClose: function () {
            campoBicicletta.disabled = true;
            aggiornaBicicletteDisponibili(dataGiornaliera.value + ' 00:00:00', dataGiornaliera.value + ' 23:59:59');
        }
    });

    flatpickr(dataInizioOraria, {
        enableTime: true,
        dateFormat: "Y-m-d H:i",
        time_24hr: true,
        disableMobile: true,
        onClose: function () {
            campoBicicletta.disabled = true;
            aggiornaBicicletteDisponibili(dataInizioOraria.value, dataFineOraria.value);
        }
    });

    flatpickr(dataFineOraria, {
        enableTime: true,
        dateFormat: "Y-m-d H:i",
        time_24hr: true,
        disableMobile: true,
        onClose: function () {
            campoBicicletta.disabled = true;
            aggiornaBicicletteDisponibili(dataInizioOraria.value, dataFineOraria.value);
        }
    });

    tipoNoleggio.addEventListener('change', function () {
        campoGiornaliero.style.display = 'none';
    campoOrario.style.display = 'none';
    campoBicicletta.disabled = true;

    if (this.value === 'giornaliero') {
        campoGiornaliero.style.display = 'block';
    } else if (this.value === 'orario') {
        campoOrario.style.display = 'block';
    }
    });

    document.querySelectorAll('.calendar-icon').forEach(function (icon) {
        icon.addEventListener('click', function () {
            const targetId = this.getAttribute('data-target');
            const targetInput = document.getElementById(targetId);
            if (targetInput._flatpickr) {
                targetInput._flatpickr.open();
            }
        });
    });
});
