<?php
/**
 * Server-side rendering of the `simple-ai-chat-embed/chat-embed` block.
 *
 * @package Simple_AI_Chat_Embed
 */

// Exit if accessed directly.
if ( ! defined( 'ABSPATH' ) ) {
    exit;
}

/**
 * Renders the `simple-ai-chat-embed/chat-embed` block on the server.
 *
 * @param array    $attributes Block attributes.
 * @param string   $content    Block default content.
 * @param WP_Block $block      Block instance.
 * @return string Returns the chat embed HTML.
 */
function simple_ai_chat_embed_render_block( $attributes, $content, $block ) {
	// Get global settings for fallback
    $settings = get_option( 'simple_ai_chat_embed_settings', [] );
    $default_chatbot_name = isset( $settings['default_chatbot_name'] ) && ! empty( trim( $settings['default_chatbot_name'] ) ) 
                            ? $settings['default_chatbot_name'] 
                            : 'AIChatBot';

    // Determine the final chatbot name for this instance
    $chatbot_name = isset( $attributes['chatbotName'] ) && ! empty( trim( $attributes['chatbotName'] ) ) 
                      ? $attributes['chatbotName'] 
                      : $default_chatbot_name;

    // Enqueue required assets for this block instance
    simple_ai_chat_embed_enqueue_assets();

    // Return the block content wrapper
    // Ensure the wrapper has the necessary data attributes for the JS to find
    // Add the common instance class
    $wrapper_attributes = get_block_wrapper_attributes(
        [
            'class' => 'simple-ai-chat-embed-instance', // Ensure common class
            'data-instance-id' => esc_attr( $attributes['instanceId'] ),
            'data-selected-model' => !empty($attributes['selectedModel']) ? esc_attr( $attributes['selectedModel'] ) : $settings['default_model'] ?? '',
            'data-initial-prompt' => !empty($attributes['initialPrompt']) ? esc_attr( $attributes['initialPrompt'] ) : $settings['default_initial_prompt'] ?? '',
            'data-chatbot-name' => esc_attr( $chatbot_name ),
            'data-is-block' => 'true' // Add flag for JS if needed
        ]
    );

	return sprintf(
        '<div %s><noscript>%s</noscript></div>',
        $wrapper_attributes,
        esc_html__( 'This chat interface requires JavaScript to be enabled.', 'simple-ai-chat-embed' )
    );
}

echo wp_kses_post(simple_ai_chat_embed_render_block($attributes, $content, $block));