<?php
defined('ABSPATH') or exit;

/**
 * ONLY EDIT THIS FILE when you add a new theme name.
 * Then add the matching .scf-theme-YOURNAME block in the CSS file.
 */
function sscfp_themes_list(): array {
    $themes = [
        'light','dark','midnight','sunset','forest','ocean',
        'rose','amber','slate','carbon',
        'glass','paper','retro',
        'violet','emerald',
        'coffee','snow','terminal'
    ];

    /**
     * Allow addons to register additional themes.
     *
     * Addons should hook into the 'sscfp_themes_list' filter and merge their
     * theme slugs into the list.
     */
    $themes = apply_filters('sscfp_themes_list', $themes);

    // Normalize + dedupe
    $themes = array_map('sanitize_key', (array)$themes);
    $themes = array_values(array_unique(array_filter($themes)));

    return $themes;
}

function sscfp_sanitize_theme($value) {
    $value = sanitize_text_field($value);
    return in_array($value, sscfp_themes_list(), true) ? $value : 'light';
}
