(function(){
  // reCAPTCHA v3 token injection (if enabled)
  function maybeSetRecaptchaV3Token(){
    var cfg = window.sscfpFront || {};
    if (!cfg.recaptchaV3SiteKey) return;
    if (typeof grecaptcha === 'undefined' || !grecaptcha.ready) return;

    grecaptcha.ready(function(){
      grecaptcha.execute(cfg.recaptchaV3SiteKey, {action:'submit'}).then(function(token){
        var el = document.getElementById('sscfp_recaptcha_token');
        if (el) el.value = token;
      });
    });
  }

  if (document.readyState === 'loading') {
    document.addEventListener('DOMContentLoaded', maybeSetRecaptchaV3Token);
  } else {
    maybeSetRecaptchaV3Token();
  }
})();
