(function(){
  function postTheme(theme){
    var cfg = window.sscfpAdmin || {};
    var data = new FormData();
    data.append('action', cfg.ajaxAction || 'sscfp_set_theme');
    data.append('nonce', cfg.nonce || '');
    data.append('theme', theme);
    var url = cfg.ajaxUrl || window.ajaxurl || '';
    return fetch(url, { method: 'POST', credentials: 'same-origin', body: data })
      .then(function(r){ return r.json(); });
  }

  document.addEventListener('click', function(e){
    var btn = e.target.closest('.scf-theme-thumb');
    if(!btn) return;

    var theme = btn.getAttribute('data-theme');
    postTheme(theme).then(function(json){
      var status = document.getElementById('scf-theme-status');
      if(!json || !json.success){
        if(status) status.textContent = (window.sscfpAdmin && window.sscfpAdmin.failText) ? window.sscfpAdmin.failText : 'Theme switch failed.';
        return;
      }

      document.querySelectorAll('.scf-theme-thumb').forEach(function(x){
        x.classList.remove('active');
        x.setAttribute('aria-pressed','false');
      });

      btn.classList.add('active');
      btn.setAttribute('aria-pressed','true');
      if(status) status.textContent = (window.sscfpAdmin && window.sscfpAdmin.okTextPrefix ? window.sscfpAdmin.okTextPrefix : 'Theme set to: ') + ((json.data && json.data.theme) ? json.data.theme : theme);
    }).catch(function(){
      var status = document.getElementById('scf-theme-status');
      if(status) status.textContent = (window.sscfpAdmin && window.sscfpAdmin.failText) ? window.sscfpAdmin.failText : 'Theme switch failed.';
    });
  });
})();
