<?php
/*
* Plugin Name: Sidebar Full-Width Toggle
* Description: Allows resizing the Gutenberg block editor sidebar to make it full-width or a custom width.
* Version: 1.1.2
* Tested up to: 6.8.3
* Author: Steve North
* Author URI: https://riweb.uk/
* License: GPL2+
* License URI: https://www.gnu.org/licenses/gpl-2.0.html
*/

if ( ! defined( 'ABSPATH' ) ) {
  exit; // Exit if accessed directly.
}

class GutenbergSidebarToggle {
  public function __construct() {
    add_action( 'enqueue_block_editor_assets', array( $this, 'enqueue_assets' ) );
  }

  public function enqueue_assets() {
    wp_enqueue_script(
      'gutenberg-sidebar-toggle',
      plugin_dir_url( __FILE__ ) . 'assets/gst.js',
      array( 'wp-blocks', 'wp-dom-ready', 'wp-edit-post' ),
      '1.1.2',
      true
    );

    wp_enqueue_style(
      'gutenberg-sidebar-toggle-style',
      plugin_dir_url( __FILE__ ) . 'assets/gst.css',
      array(),
      '1.1.2'
    );
  }
}

// Init plugin
if ( is_admin() ) {
  new GutenbergSidebarToggle();
}