(function (wp) {
  const { subscribe } = wp.data;
  const { select } = wp.data;

  function injectButtonIntoBlockCard() {
    const blockCard = document.querySelector('.components-panel__header.editor-sidebar__panel-tabs');

    if (blockCard && !blockCard.querySelector('.gst-button')) {
      const buttonContainer = document.createElement('div');
      buttonContainer.className = 'gst-button';
      buttonContainer.style.cssText = `flex-grow: 1;`;

      const button = document.createElement('button');
      button.className = 'components-button';
      button.innerHTML = '<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 24 24" width="24" height="24" aria-hidden="true" focusable="false"><path d="M6 4a2 2 0 0 0-2 2v3h1.5V6a.5.5 0 0 1 .5-.5h3V4H6Zm3 14.5H6a.5.5 0 0 1-.5-.5v-3H4v3a2 2 0 0 0 2 2h3v-1.5Zm6 1.5v-1.5h3a.5.5 0 0 0 .5-.5v-3H20v3a2 2 0 0 1-2 2h-3Zm3-16a2 2 0 0 1 2 2v3h-1.5V6a.5.5 0 0 0-.5-.5h-3V4h3Z"></path></svg>';
      button.addEventListener('click', function () {
        document.body.classList.toggle('gst-button-active');
      });

      buttonContainer.appendChild(button);
      blockCard.appendChild(buttonContainer);
    }
  }

  function cleanupOldButtons() {
    const oldButtons = document.querySelectorAll('.gst-button');
    oldButtons.forEach(button => button.remove());
  }

  function initResize() {
    const sidebar = document.querySelector('.interface-interface-skeleton__sidebar');

    if (!sidebar || sidebar.dataset.resizeInitialized) return;

    sidebar.dataset.resizeInitialized = 'true';

    let isResizing = false;
    let startX = 0;
    let startWidth = 0;

    sidebar.addEventListener('mousedown', function (e) {
      const rect = sidebar.getBoundingClientRect();
      if (e.clientX - rect.left < 4) {
        isResizing = true;
        startX = e.clientX;
        startWidth = parseInt(window.getComputedStyle(sidebar).width, 10);
        document.body.style.cursor = 'ew-resize';
        e.preventDefault();
      }
    });

    document.addEventListener('mousemove', function (e) {
      if (!isResizing) return;

      const diff = startX - e.clientX;
      const newWidth = startWidth + diff;

      sidebar.style.width = newWidth + 'px';
    });

    document.addEventListener('mouseup', function () {
      isResizing = false;
      document.body.style.cursor = '';
    });
  }

  let unsubscribe = subscribe(() => {
    const isEditorReady = select('core/editor') && select('core/block-editor');

    if (isEditorReady) {
      setTimeout(() => {
        injectButtonIntoBlockCard();
        initResize();
      }, 1000);

      unsubscribe();
    }
  });

  let previousSelectedBlockId = null;
  subscribe(() => {
    const selectedBlock = select('core/block-editor')?.getSelectedBlock();
    const currentSelectedBlockId = selectedBlock ? selectedBlock.clientId : null;

    if (currentSelectedBlockId !== previousSelectedBlockId) {
      previousSelectedBlockId = currentSelectedBlockId;

      setTimeout(() => {
        cleanupOldButtons();
        if (currentSelectedBlockId) {
          injectButtonIntoBlockCard();
          initResize();
        }
      }, 100);
    }
  });
})(window.wp);