function copyLink(link) {
    var tempInput = document.createElement("input");
    tempInput.value = link;
    document.body.appendChild(tempInput);
    tempInput.select();
    document.execCommand("copy");
    document.body.removeChild(tempInput);
    alert("Link copied: " + link);
}

function generateQR(shortlink) {
    if (typeof qr_data.nonce === 'undefined') {
        console.error('Nonce is not defined');
        return;
    }

    jQuery.ajax({
        url: qr_data.ajax_url,
        type: 'POST',
        data: {
            action: 'generate_qr_code',
            shortlink: shortlink,
            nonce: qr_data.nonce
        },
        success: function(response) {
            if (response.success) {
                jQuery('#qr-shortlink').text(shortlink);
                jQuery('#qr-image').attr('src', response.data.qr_url);
                jQuery('#qr-download').attr('href', response.data.qr_url);
                jQuery('#qr-modal').show();
            } else {
                alert('Failed to generate QR code');
            }
        }
    });
}

// Close modal when clicking the close button
jQuery(document).on('click', '.close-modal', function() {
    jQuery('#qr-modal').hide();
});

