jQuery(document).ready(function ($) {
            
    // --- Pro Feature Modal Logic ---
    function showProModal() {
        $('#shorterm-pro-modal').fadeIn();
    }

    function closeProModal() {
        $('#shorterm-pro-modal').fadeOut();
    }

    // Use a delegate selector for dynamically added elements
    $(document).on('click', '.pro-feature-button, .pro-feature-control', function(e) {
        e.preventDefault();
        e.stopPropagation();
        showProModal();
    });

    $('#shorterm-close-modal, .shorterm-modal-overlay').on('click', function() {
        closeProModal();
    });

    // --- Core Functionality (Free Version) ---
     $('#shorterm-form').on('submit', function (e) {
        e.preventDefault();
        const originalUrl = $('#original_url').val();

        if (!originalUrl) {
            $('#shorterm-messages').html('<div class="error"><p>Original URL is required.</p></div>');
            return;
        }

      $.ajax({
           url: shorterm_ajax_object.ajax_url, // Use localized variable
           method: 'POST',
            data: {
               action: 'shorterm_create_link',
                original_url: originalUrl,
               '_wpnonce': shorterm_ajax_object.create_link_nonce // Use localized variable
           },
           success: function (response) {
                if (response.success) {
                    $('#shorterm-messages').html('<div class="updated"><p><strong>Short URL generated: </strong><a href="' + response.data.short_url + '" target="_blank">' + response.data.short_url + '</a></p></div>');
                    refreshLinksTable();
                    $('#shorterm-form')[0].reset();
               } else {
                   $('#shorterm-messages').html('<div class="error"><p><strong>Error:</strong> ' + response.data + '</p></div>');
                }
           },
             error: function(){
                $('#shorterm-messages').html('<div class="error"><p><strong>AJAX Error:</strong> An error occurred. Please try again.</p></div>');
           }
       });
   });

  function refreshLinksTable() {
        $.ajax({
            url: shorterm_ajax_object.ajax_url, // Use localized variable
            method: 'POST',
            data: {
               action: 'shorterm_refresh_table',
               '_wpnonce': shorterm_ajax_object.refresh_table_nonce // Use localized variable
           },
           success: function (response) {
               if (response.success) {
                   $('#shorterm-links-body').html(response.data);
               } else {
                   $('#shorterm-links-body').html('<tr><td colspan="5" style="text-align:center; padding: 20px; color: var(--danger-color);">Error loading links. Please try again.</td></tr>');
               }
           },
           error: function() {
               $('#shorterm-links-body').html('<tr><td colspan="5" style="text-align:center; padding: 20px; color: var(--danger-color);">Error loading links. Please try again.</td></tr>');
           }
      });
  }

    // Use a delegate selector for dynamically loaded content
    $(document).on('click', ".copy-link", function () {
        const linkToCopy = $(this).data('link');
        navigator.clipboard.writeText(linkToCopy).then(() => {
        const originalText = $(this).html();
        $(this).html('<i class="dashicons dashicons-yes-alt"></i> Copied!').addClass('copied');
        setTimeout(() => {
            $(this).html(originalText).removeClass('copied');
        }, 1500);
        });
    });

    $(document).on('click', ".delete-link", function () {
        const linkId = $(this).data('id');
        const nonce = $(this).data('nonce');

        if (confirm('Are you sure you want to delete this link? This action cannot be undone.')) {
            $.ajax({
                url: shorterm_ajax_object.ajax_url, // Use localized variable
                method: 'POST',
                data: {
                    action: 'shorterm_delete_link',
                    id: linkId,
                    '_wpnonce': nonce
                },
                success: function (response) {
                    if (response.success) {
                        $('#shorterm-messages').html('<div class="updated"><p>Link deleted successfully.</p></div>');
                        refreshLinksTable();
                    } else {
                        $('#shorterm-messages').html('<div class="error"><p>Error deleting link: ' + (response.data || 'Unknown error') + '</p></div>');
                    }
                },
                error: function() {
                    $('#shorterm-messages').html('<div class="error"><p>An error occurred. Could not delete link.</p></div>');
                }
            });
        }
    });

});