<?php
/**
 * منوی ادمین — تنظیمات و صفحهٔ ساخت لینک کوتاه
 */

defined('ABSPATH') || exit;

class Slfm8c_Admin_Menu {

    public static function init(): void {
        add_action('admin_menu', [__CLASS__, 'add_menus']);
        add_action('admin_enqueue_scripts', [__CLASS__, 'enqueue_my_links_assets']);
    }

    public static function add_menus(): void {
        add_menu_page(
            __('لینک کوتاه M8C', 'short-links-for-m8c'),
            __('لینک کوتاه M8C', 'short-links-for-m8c'),
            'edit_posts',
            'short-links-for-m8c',
            [Slfm8c_Shortlink_Page::class, 'render_page'],
            'dashicons-admin-links',
            30
        );
        add_submenu_page(
            'short-links-for-m8c',
            __('ساخت لینک کوتاه', 'short-links-for-m8c'),
            __('ساخت لینک کوتاه', 'short-links-for-m8c'),
            'edit_posts',
            'short-links-for-m8c',
            [Slfm8c_Shortlink_Page::class, 'render_page']
        );
        add_submenu_page(
            'short-links-for-m8c',
            __('لینک‌های من', 'short-links-for-m8c'),
            __('لینک‌های من', 'short-links-for-m8c'),
            'edit_posts',
            'short-links-for-m8c-my-links',
            [__CLASS__, 'render_my_links_page']
        );
        add_submenu_page(
            'short-links-for-m8c',
            __('تنظیمات M8C', 'short-links-for-m8c'),
            __('تنظیمات', 'short-links-for-m8c'),
            'manage_options',
            'short-links-for-m8c-settings',
            [__CLASS__, 'render_settings_page']
        );
    }

    /**
     * Enqueue CSS/JS for My Links page via wp_enqueue (no inline style/script in view).
     */
    public static function enqueue_my_links_assets(string $hook): void {
        if ($hook !== 'short-links-for-m8c_page_short-links-for-m8c-my-links') {
            return;
        }
        $inline_css = '.mak-my-links-wrap .column-short-url code { word-break: break-all; }
.mak-my-links-wrap .column-url .mak-dest-url { max-width: 240px; display: inline-block; overflow: hidden; text-overflow: ellipsis; white-space: nowrap; }
.mak-my-links-wrap .tablenav-pages { margin-top: 12px; }';
        wp_register_style('slfm8c-my-links', false, [], SLFM8C_VERSION);
        wp_add_inline_style('slfm8c-my-links', $inline_css);
        wp_enqueue_style('slfm8c-my-links');

        $copied = __('کپی شد.', 'short-links-for-m8c');
        $inline_js = "(function(){ document.querySelectorAll('.mak-copy-btn').forEach(function(btn){ btn.addEventListener('click',function(){ var url=this.getAttribute('data-url'); if(url&&navigator.clipboard&&navigator.clipboard.writeText){ navigator.clipboard.writeText(url).then(function(){ var t=btn.textContent; btn.textContent=" . wp_json_encode($copied) . "; setTimeout(function(){ btn.textContent=t; }, 1500); }); } }); }); })();";
        wp_register_script('slfm8c-my-links', false, [], SLFM8C_VERSION, true);
        wp_add_inline_script('slfm8c-my-links', $inline_js);
        wp_enqueue_script('slfm8c-my-links');
    }

    public static function render_my_links_page(): void {
        if (!current_user_can('edit_posts')) {
            return;
        }
        $page = isset($_GET['paged']) ? max(1, (int) $_GET['paged']) : 1;
        $per_page = 15;
        $result = null;
        if (Slfm8c_Api_Client::is_configured()) {
            $client = Slfm8c_Api_Client::from_settings();
            $result = $client->get_my_links($page, $per_page);
        }
        include SLFM8C_PLUGIN_DIR . '/admin/views/my-links.php';
    }

    public static function render_settings_page(): void {
        if (!current_user_can('manage_options')) {
            return;
        }
        $api_base = Slfm8c_Settings::get_api_base_url();
        $api_token = Slfm8c_Settings::get_api_token();
        include SLFM8C_PLUGIN_DIR . '/admin/views/settings.php';
    }
}
