<?php
defined('ABSPATH') || exit;
?>
<div class="wrap mak-shortlinks-wrap" style="max-width: 560px;">
    <h1><?php echo esc_html__('ساخت لینک کوتاه', 'short-links-for-m8c'); ?></h1>

    <?php if (!$configured): ?>
        <div class="notice notice-warning">
            <p><?php echo esc_html__('برای استفاده، ابتدا در بخش «تنظیمات» پلاگین M8C، آدرس API و توکن را وارد کنید.', 'short-links-for-m8c'); ?>
                <a href="<?php echo esc_url(admin_url('admin.php?page=short-links-for-m8c-settings')); ?>"><?php echo esc_html__('رفتن به تنظیمات', 'short-links-for-m8c'); ?></a>
            </p>
        </div>
    <?php endif; ?>

    <?php if ($result !== null): ?>
        <?php if (!empty($result['success'])): ?>
            <div class="notice notice-success">
                <p><strong><?php echo esc_html__('لینک کوتاه ساخته شد:', 'short-links-for-m8c'); ?></strong><br>
                    <code id="mak-result-url"><?php echo esc_html($result['short_url']); ?></code>
                    <button type="button" class="button button-small" onclick="navigator.clipboard.writeText(document.getElementById('mak-result-url').textContent); this.textContent='<?php echo esc_js(__('کپی شد.', 'short-links-for-m8c')); ?>';"><?php echo esc_html__('کپی', 'short-links-for-m8c'); ?></button>
                </p>
            </div>
        <?php else: ?>
            <div class="notice notice-error">
                <p><?php echo esc_html($result['error'] ?? __('خطای نامشخص.', 'short-links-for-m8c')); ?></p>
            </div>
        <?php endif; ?>
    <?php endif; ?>

    <form method="post" action="" class="mak-shortlinks-form">
        <?php wp_nonce_field('slfm8c_create_shortlink', 'slfm8c_create_shortlink_nonce'); ?>
        <table class="form-table" role="presentation">
            <tr>
                <th scope="row"><label for="mak_url"><?php echo esc_html__('آدرس بلند (URL)', 'short-links-for-m8c'); ?></label></th>
                <td>
                    <input type="url" name="url" id="mak_url" value="<?php echo isset($_POST['url']) ? esc_attr(sanitize_url(wp_unslash($_POST['url']))) : ''; ?>" class="large-text" required placeholder="https://example.com/page">
                </td>
            </tr>
            <tr>
                <th scope="row"><label for="mak_code_length"><?php echo esc_html__('طول کد', 'short-links-for-m8c'); ?></label></th>
                <td>
                    <input type="number" name="code_length" id="mak_code_length" value="3" min="3" max="16" class="small-text">
                    <p class="description"><?php echo esc_html__('۳ تا ۱۶ کاراکتر (پیش‌فرض: ۳)', 'short-links-for-m8c'); ?></p>
                </td>
            </tr>
            <tr>
                <th scope="row"><label for="mak_password"><?php echo esc_html__('رمز (اختیاری)', 'short-links-for-m8c'); ?></label></th>
                <td>
                    <input type="text" name="password" id="mak_password" value="" class="regular-text" autocomplete="off">
                </td>
            </tr>
        </table>
        <p class="submit">
            <button type="submit" class="button button-primary" <?php echo $configured ? '' : 'disabled'; ?>>
                <?php echo esc_html__('ساخت لینک کوتاه', 'short-links-for-m8c'); ?>
            </button>
        </p>
    </form>
</div>
