<?php
defined('ABSPATH') || exit;
?>
<div class="wrap" style="max-width: 600px;">
    <h1><?php echo esc_html__('تنظیمات لینک کوتاه M8C', 'short-links-for-m8c'); ?></h1>
    <form method="post" action="options.php">
        <?php settings_fields(Slfm8c_Settings::OPTION_GROUP); ?>
        <table class="form-table" role="presentation">
            <tr>
                <th scope="row">
                    <label for="mak_api_base"><?php echo esc_html__('آدرس پایه API', 'short-links-for-m8c'); ?></label>
                </th>
                <td>
                    <input type="url" name="<?php echo esc_attr(Slfm8c_Settings::OPTION_API_BASE); ?>" id="mak_api_base"
                           value="<?php echo esc_attr(Slfm8c_Settings::get_api_base_url()); ?>"
                           class="regular-text" placeholder="https://m8c.ir/api">
                    <p class="description"><?php echo esc_html__('مثال: https://m8c.ir/api (بدون اسلش در انتها)', 'short-links-for-m8c'); ?></p>
                </td>
            </tr>
            <tr>
                <th scope="row">
                    <label for="mak_api_token"><?php echo esc_html__('توکن API', 'short-links-for-m8c'); ?></label>
                </th>
                <td>
                    <input type="password" name="<?php echo esc_attr(Slfm8c_Settings::OPTION_API_TOKEN); ?>" id="mak_api_token"
                           value="<?php echo esc_attr(Slfm8c_Settings::get_api_token()); ?>"
                           class="regular-text" autocomplete="off">
                    <p class="description"><?php echo esc_html__('توکن را از پنل M8C، بخش «توسعه‌دهندگان» کپی کنید.', 'short-links-for-m8c'); ?></p>
                </td>
            </tr>
        </table>
        <?php submit_button(__('ذخیره تنظیمات', 'short-links-for-m8c')); ?>
    </form>
</div>
