<?php
/**
 * Plugin Name: Short Links for M8C — لینک کوتاه
 * Plugin URI: https://m8c.ir
 * Description: ساخت لینک کوتاه برای محصولات و مطالب با اتصال به سرویس M8C
 * Version: 1.0.1
 * Author: m8c
 * License: GPLv2 or later
 * License URI: https://www.gnu.org/licenses/gpl-2.0.html
 * Text Domain: short-links-for-m8c
 * Domain Path: /languages
 * Requires at least: 5.9
 * Requires PHP: 7.4
 *
 * سازگار با وردپرس 5.9 و بالاتر، PHP 7.4 و بالاتر.
 */

defined('ABSPATH') || exit;

const SLFM8C_VERSION = '1.0.1';
const SLFM8C_PLUGIN_DIR = __DIR__;
const SLFM8C_PLUGIN_BASENAME = 'mak-wp-plugin/mak-shortlinks.php';
define('SLFM8C_PLUGIN_URL', plugin_dir_url(__FILE__));

require_once SLFM8C_PLUGIN_DIR . '/includes/class-mak-api-client.php';
require_once SLFM8C_PLUGIN_DIR . '/includes/class-mak-settings.php';
require_once SLFM8C_PLUGIN_DIR . '/includes/class-mak-admin-menu.php';
require_once SLFM8C_PLUGIN_DIR . '/includes/class-mak-shortlink-page.php';
require_once SLFM8C_PLUGIN_DIR . '/includes/class-mak-product-metabox.php';

add_action('plugins_loaded', function () {
    Slfm8c_Settings::init();
    Slfm8c_Admin_Menu::init();
    Slfm8c_Shortlink_Page::init();
    Slfm8c_Product_Metabox::init();
});

register_activation_hook(__FILE__, function () {
    // آینده: ایجاد جداول یا گزینه‌های پیش‌فرض در صورت نیاز
});
