<?php
/**
 * صفحهٔ ساخت لینک کوتاه در منوی سمت راست وردپرس
 */

defined('ABSPATH') || exit;

class Slfm8c_Shortlink_Page {

    public static function init(): void {
        add_action('admin_enqueue_scripts', [__CLASS__, 'enqueue_scripts']);
    }

    public static function enqueue_scripts(string $hook): void {
        if ($hook !== 'toplevel_page_short-links-for-m8c') {
            return;
        }
        wp_enqueue_style(
            'slfm8c-shortlinks-admin',
            SLFM8C_PLUGIN_URL . 'assets/admin.css',
            [],
            SLFM8C_VERSION
        );
    }

    public static function render_page(): void {
        if (!current_user_can('edit_posts')) {
            return;
        }
        $configured = Slfm8c_Api_Client::is_configured();
        $result = null;
        if (isset($_SERVER['REQUEST_METHOD']) && $_SERVER['REQUEST_METHOD'] === 'POST' && isset($_POST['slfm8c_create_shortlink_nonce']) && wp_verify_nonce(sanitize_text_field(wp_unslash($_POST['slfm8c_create_shortlink_nonce'])), 'slfm8c_create_shortlink')) {
            $result = self::handle_create();
        }
        include SLFM8C_PLUGIN_DIR . '/admin/views/shortlink-page.php';
    }

    private static function handle_create(): array {
        $url = isset($_POST['url']) ? sanitize_url(wp_unslash($_POST['url'])) : '';
        $url = $url ? trim($url) : '';
        $code_length = isset($_POST['code_length']) ? max(3, min(16, (int) $_POST['code_length'])) : 3;
        $password = isset($_POST['password']) ? sanitize_text_field(wp_unslash($_POST['password'])) : '';

        if ($url === '') {
            return ['success' => false, 'error' => __('آدرس URL را وارد کنید.', 'short-links-for-m8c')];
        }
        if (!Slfm8c_Api_Client::is_configured()) {
            return ['success' => false, 'error' => __('ابتدا در بخش تنظیمات، آدرس API و توکن را وارد کنید.', 'short-links-for-m8c')];
        }

        $client = Slfm8c_Api_Client::from_settings();
        return $client->create_short_link($url, $code_length, $password);
    }
}
