<?php
/**
 * تنظیمات پلاگین — آدرس API و توکن
 */

defined('ABSPATH') || exit;

class Slfm8c_Settings {

    const OPTION_GROUP = 'slfm8c_shortlinks_settings';
    const OPTION_API_BASE = 'slfm8c_shortlinks_api_base_url';
    const OPTION_API_TOKEN = 'slfm8c_shortlinks_api_token';

    public static function init(): void {
        add_action('admin_init', [__CLASS__, 'register_settings']);
        add_action('admin_init', [__CLASS__, 'migrate_old_options'], 5);
    }

    /**
     * یک‌بار مهاجرت از گزینه‌های قدیمی mak_* به slfm8c_*
     */
    public static function migrate_old_options(): void {
        if (get_option('slfm8c_shortlinks_migrated')) {
            return;
        }
        $old_base = get_option('mak_shortlinks_api_base_url');
        $old_token = get_option('mak_shortlinks_api_token');
        if ($old_base !== false) {
            update_option(self::OPTION_API_BASE, $old_base);
            delete_option('mak_shortlinks_api_base_url');
        }
        if ($old_token !== false) {
            update_option(self::OPTION_API_TOKEN, $old_token);
            delete_option('mak_shortlinks_api_token');
        }
        update_option('slfm8c_shortlinks_migrated', '1');
    }

    public static function register_settings(): void {
        register_setting(self::OPTION_GROUP, self::OPTION_API_BASE, [
            'type'              => 'string',
            'sanitize_callback' => function ($value) {
                return esc_url_raw(trim((string) $value));
            },
        ]);
        register_setting(self::OPTION_GROUP, self::OPTION_API_TOKEN, [
            'type'              => 'string',
            'sanitize_callback' => function ($value) {
                return sanitize_text_field(trim((string) $value));
            },
        ]);
    }

    public static function get_api_base_url(): string {
        $url = get_option(self::OPTION_API_BASE, '');
        return is_string($url) ? $url : '';
    }

    public static function get_api_token(): string {
        $token = get_option(self::OPTION_API_TOKEN, '');
        return is_string($token) ? $token : '';
    }
}
