<?php
/**
 * متاباکس لینک کوتاه برای محصولات (ووکامرس) و نوشته‌ها
 */

defined('ABSPATH') || exit;

class Slfm8c_Product_Metabox {

    public static function init(): void {
        add_action('add_meta_boxes', [__CLASS__, 'add_metabox']);
        add_action('admin_enqueue_scripts', [__CLASS__, 'enqueue_scripts']);
        add_action('wp_ajax_slfm8c_create_shortlink_metabox', [__CLASS__, 'ajax_create_shortlink']);
    }

    public static function add_metabox(): void {
        $screens = ['post', 'page'];
        if (class_exists('WooCommerce')) {
            $screens[] = 'product';
        }
        foreach ($screens as $screen) {
            add_meta_box(
                'slfm8c_shortlink_metabox',
                __('لینک کوتاه M8C', 'short-links-for-m8c'),
                [__CLASS__, 'render_metabox'],
                $screen,
                'side',
                'default'
            );
        }
    }

    public static function enqueue_scripts(string $hook): void {
        global $post;
        if (!in_array($hook, ['post.php', 'post-new.php'], true) || !$post) {
            return;
        }
        $post_type = $post->post_type;
        if (!in_array($post_type, ['post', 'page', 'product'], true)) {
            return;
        }
        wp_enqueue_style(
            'slfm8c-metabox',
            SLFM8C_PLUGIN_URL . 'assets/metabox.css',
            [],
            SLFM8C_VERSION
        );
        wp_enqueue_script(
            'slfm8c-metabox',
            SLFM8C_PLUGIN_URL . 'assets/metabox.js',
            ['jquery'],
            SLFM8C_VERSION,
            true
        );
        wp_localize_script('slfm8c-metabox', 'slfm8cMetabox', [
            'ajaxUrl' => admin_url('admin-ajax.php'),
            'nonce'   => wp_create_nonce('slfm8c_metabox_shortlink'),
            'i18n'    => [
                'creating'   => __('در حال ساخت…', 'short-links-for-m8c'),
                'error'      => __('خطا در ساخت لینک.', 'short-links-for-m8c'),
                'copy'       => __('کپی', 'short-links-for-m8c'),
                'copied'     => __('کپی شد.', 'short-links-for-m8c'),
                'create_btn' => __('ساخت لینک کوتاه', 'short-links-for-m8c'),
            ],
        ]);
    }

    public static function render_metabox(\WP_Post $post): void {
        $permalink = get_permalink($post);
        if (!$permalink) {
            echo '<p>' . esc_html__('پرمالینک در دسترس نیست.', 'short-links-for-m8c') . '</p>';
            return;
        }
        $configured = Slfm8c_Api_Client::is_configured();
        $saved_url = get_post_meta($post->ID, '_slfm8c_shortlink_url', true);
        $saved_code = get_post_meta($post->ID, '_slfm8c_shortlink_code', true);
        if (!$saved_url && get_post_meta($post->ID, '_mak_shortlink_url', true)) {
            $saved_url = get_post_meta($post->ID, '_mak_shortlink_url', true);
            $saved_code = get_post_meta($post->ID, '_mak_shortlink_code', true);
            update_post_meta($post->ID, '_slfm8c_shortlink_url', $saved_url);
            update_post_meta($post->ID, '_slfm8c_shortlink_code', $saved_code);
        }
        ?>
        <div class="mak-metabox-wrap" data-permalink="<?php echo esc_attr($permalink); ?>" data-post-id="<?php echo esc_attr((string) $post->ID); ?>">
            <?php if (!$configured): ?>
                <p class="mak-metabox-notice"><?php echo esc_html__('برای ساخت لینک کوتاه، در تنظیمات پلاگین M8C، آدرس API و توکن را وارد کنید.', 'short-links-for-m8c'); ?></p>
                <p><a href="<?php echo esc_url(admin_url('admin.php?page=short-links-for-m8c-settings')); ?>"><?php echo esc_html__('رفتن به تنظیمات', 'short-links-for-m8c'); ?></a></p>
            <?php else: ?>
                <?php if (!empty($saved_url)): ?>
                    <p class="mak-metabox-saved-label"><small><?php echo esc_html__('لینک کوتاه ایجادشده:', 'short-links-for-m8c'); ?></small></p>
                    <p class="mak-metabox-saved-url">
                        <code class="mak-saved-short-url"><?php echo esc_html($saved_url); ?></code>
                        <button type="button" class="button button-small mak-metabox-copy-saved"><?php echo esc_html__('کپی', 'short-links-for-m8c'); ?></button>
                    </p>
                    <p class="mak-metabox-divider"><small><?php echo esc_html__('ساخت لینک جدید (جایگزین می‌شود):', 'short-links-for-m8c'); ?></small></p>
                <?php else: ?>
                    <p class="mak-metabox-url"><small><?php echo esc_html__('آدرس:', 'short-links-for-m8c'); ?></small><br><code><?php echo esc_html($permalink); ?></code></p>
                <?php endif; ?>
                <p>
                    <button type="button" class="button button-primary mak-metabox-create"><?php echo esc_html(!empty($saved_url) ? __('ساخت لینک کوتاه جدید', 'short-links-for-m8c') : __('ساخت لینک کوتاه', 'short-links-for-m8c')); ?></button>
                </p>
                <div class="mak-metabox-result" style="display:none;"></div>
            <?php endif; ?>
        </div>
        <?php
    }

    public static function ajax_create_shortlink(): void {
        check_ajax_referer('slfm8c_metabox_shortlink', 'nonce');
        if (!current_user_can('edit_posts')) {
            wp_send_json_error(['message' => 'Unauthorized']);
        }
        $url = isset($_POST['url']) ? sanitize_url(wp_unslash($_POST['url'])) : '';
        $url = $url ? trim($url) : '';
        $post_id = isset($_POST['post_id']) ? (int) $_POST['post_id'] : 0;
        if ($url === '') {
            wp_send_json_error(['message' => 'URL required']);
        }
        if (!Slfm8c_Api_Client::is_configured()) {
            wp_send_json_error(['message' => 'Plugin not configured']);
        }
        $client = Slfm8c_Api_Client::from_settings();
        $result = $client->create_short_link($url, 3, '');
        if (!empty($result['success']) && !empty($result['short_url'])) {
            $short_url = $result['short_url'];
            $code = isset($result['code']) ? $result['code'] : '';
            if ($post_id > 0 && get_post($post_id)) {
                update_post_meta($post_id, '_slfm8c_shortlink_url', $short_url);
                update_post_meta($post_id, '_slfm8c_shortlink_code', $code);
            }
            wp_send_json_success(['short_url' => $short_url, 'code' => $code]);
        }
        wp_send_json_error(['message' => $result['error'] ?? 'Unknown error']);
    }
}
