(function ($) {
    $(function () {
        $(document).on('click', '.mak-metabox-copy-saved', function () {
            var $wrap = $(this).closest('.mak-metabox-wrap');
            var url = $wrap.find('.mak-saved-short-url').text();
            if (url && navigator.clipboard && navigator.clipboard.writeText) {
                navigator.clipboard.writeText(url).then(function () {
                    var $btn = $wrap.find('.mak-metabox-copy-saved');
                    var prev = $btn.text();
                    $btn.text(slfm8cMetabox.i18n.copied);
                    setTimeout(function () { $btn.text(prev); }, 1500);
                });
            }
        });

        $(document).on('click', '.mak-metabox-create', function () {
            var $btn = $(this);
            var $wrap = $btn.closest('.mak-metabox-wrap');
            var $result = $wrap.find('.mak-metabox-result');
            var url = $wrap.data('permalink');
            var postId = $wrap.data('post-id');
            if (!url) return;
            $btn.prop('disabled', true).text(slfm8cMetabox.i18n.creating);
            $result.hide().removeClass('success error').empty();
            $.post(slfm8cMetabox.ajaxUrl, {
                action: 'slfm8c_create_shortlink_metabox',
                nonce: slfm8cMetabox.nonce,
                url: url,
                post_id: postId || ''
            })
                .done(function (res) {
                    if (res.success && res.data.short_url) {
                        $result.addClass('success')
                            .html(
                                '<span class="short-url">' + $('<div>').text(res.data.short_url).html() + '</span>' +
                                '<br><button type="button" class="button button-small copy-btn">' + slfm8cMetabox.i18n.copy + '</button>'
                            )
                            .find('.copy-btn').on('click', function () {
                                navigator.clipboard.writeText(res.data.short_url);
                                $(this).text(slfm8cMetabox.i18n.copied);
                            });
                        $result.show();
                        setTimeout(function () { location.reload(); }, 800);
                    } else {
                        $result.addClass('error').text(res.data && res.data.message ? res.data.message : slfm8cMetabox.i18n.error);
                        $result.show();
                    }
                })
                .fail(function () {
                    $result.addClass('error').text(slfm8cMetabox.i18n.error);
                    $result.show();
                })
                .always(function () {
                    $btn.prop('disabled', false).text(slfm8cMetabox.i18n.create_btn || 'ساخت لینک کوتاه');
                });
        });
    });
})(jQuery);
