<?php
/**
 * صفحهٔ «لینک‌های من» — لیست لینک‌های ایجادشده با وب‌سرویس (در لحظه از API)
 */
defined('ABSPATH') || exit;

$base_url = admin_url('admin.php?page=short-links-for-m8c-my-links');
?>
<div class="wrap mak-my-links-wrap">
    <h1><?php echo esc_html__('لینک‌های من', 'short-links-for-m8c'); ?></h1>
    <p class="description"><?php echo esc_html__('لیست لینک‌های کوتاهی که با همین سایت (وب‌سرویس) ایجاد شده‌اند؛ به‌صورت زنده از سرور M8C دریافت می‌شود.', 'short-links-for-m8c'); ?></p>

    <?php if (!Slfm8c_Api_Client::is_configured()) : ?>
        <div class="notice notice-warning">
            <p><?php echo esc_html__('برای مشاهده لیست، ابتدا در بخش تنظیمات، آدرس API و توکن را وارد کنید.', 'short-links-for-m8c'); ?>
                <a href="<?php echo esc_url(admin_url('admin.php?page=short-links-for-m8c-settings')); ?>"><?php echo esc_html__('رفتن به تنظیمات', 'short-links-for-m8c'); ?></a>
            </p>
        </div>
        <?php return;
    endif; ?>

    <?php if ($result && !empty($result['success']) && isset($result['data'])) : ?>
        <?php
        $items = $result['data'];
        $total = isset($result['total']) ? (int) $result['total'] : 0;
        $current_page = isset($result['current_page']) ? (int) $result['current_page'] : 1;
        $last_page = isset($result['last_page']) ? (int) $result['last_page'] : 1;
        $from = isset($result['from']) ? (int) $result['from'] : 0;
        $to = isset($result['to']) ? (int) $result['to'] : 0;
        ?>
        <?php if ($total === 0) : ?>
            <p><?php echo esc_html__('هنوز لینکی با وب‌سرویس ایجاد نکرده‌اید. از بخش «ساخت لینک کوتاه» یا متاباکس محصول/نوشته می‌توانید لینک بسازید.', 'short-links-for-m8c'); ?></p>
        <?php else : ?>
            <p class="mak-links-summary">
                <?php
                printf(
                    /* translators: 1: from, 2: to, 3: total */
                    esc_html__('نمایش %1$s تا %2$s از %3$s لینک.', 'short-links-for-m8c'),
                    esc_html(number_format_i18n($from)),
                    esc_html(number_format_i18n($to)),
                    esc_html(number_format_i18n($total))
                );
                ?>
            </p>
            <table class="wp-list-table widefat fixed striped">
                <thead>
                    <tr>
                        <th scope="col" class="column-code"><?php echo esc_html__('کد', 'short-links-for-m8c'); ?></th>
                        <th scope="col" class="column-short-url"><?php echo esc_html__('لینک کوتاه', 'short-links-for-m8c'); ?></th>
                        <th scope="col" class="column-url"><?php echo esc_html__('آدرس مقصد', 'short-links-for-m8c'); ?></th>
                        <th scope="col" class="column-clicks"><?php echo esc_html__('کلیک', 'short-links-for-m8c'); ?></th>
                        <th scope="col" class="column-actions"><?php echo esc_html__('عملیات', 'short-links-for-m8c'); ?></th>
                    </tr>
                </thead>
                <tbody>
                    <?php foreach ($items as $row) : ?>
                        <tr>
                            <td class="column-code"><code><?php echo esc_html($row['code']); ?></code></td>
                            <td class="column-short-url">
                                <code class="mak-short-url-cell"><?php echo esc_html($row['short_url']); ?></code>
                            </td>
                            <td class="column-url" title="<?php echo esc_attr($row['url']); ?>">
                                <span class="mak-dest-url"><?php echo esc_html(wp_trim_words($row['url'], 8)); ?></span>
                            </td>
                            <td class="column-clicks"><?php echo esc_html(number_format_i18n((int) ($row['clicks_count'] ?? 0))); ?></td>
                            <td class="column-actions">
                                <a href="<?php echo esc_url($row['short_url']); ?>" target="_blank" rel="noopener" class="button button-small"><?php echo esc_html__('باز کردن', 'short-links-for-m8c'); ?></a>
                                <button type="button" class="button button-small mak-copy-btn" data-url="<?php echo esc_attr($row['short_url']); ?>"><?php echo esc_html__('کپی', 'short-links-for-m8c'); ?></button>
                            </td>
                        </tr>
                    <?php endforeach; ?>
                </tbody>
            </table>

            <?php if ($last_page > 1) : ?>
                <div class="tablenav bottom">
                    <div class="tablenav-pages">
                        <span class="displaying-num">
                            <?php echo esc_html(sprintf(/* translators: %s: number */ __('%s مورد', 'short-links-for-m8c'), number_format_i18n($total))); ?>
                        </span>
                        <span class="pagination-links">
                            <?php
                            $links = paginate_links([
                                'base' => add_query_arg('paged', '%#%', $base_url),
                                'format' => '',
                                'prev_text' => '&laquo;',
                                'next_text' => '&raquo;',
                                'total' => $last_page,
                                'current' => $current_page,
                            ]);
                            echo $links ? wp_kses_post($links) : '';
                            ?>
                        </span>
                    </div>
                </div>
            <?php endif; ?>
        <?php endif; ?>
    <?php elseif ($result && !empty($result['error'])) : ?>
        <div class="notice notice-error">
            <p><?php echo esc_html($result['error']); ?></p>
        </div>
    <?php else : ?>
        <p><?php echo esc_html__('دریافت لیست از سرور انجام نشد. اتصال یا توکن را بررسی کنید.', 'short-links-for-m8c'); ?></p>
    <?php endif; ?>
</div>
