<?php
/**
 * Language helper class for ShopWriter Lite
 *
 * @since      1.0.0
 * @package    ShopWriter_Lite
 */

// If this file is called directly, abort.
if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

/**
 * Language helper class for handling multilingual functionality
 *
 * @since 1.0.0
 */
class SHOPWR_Lite_Language_Helper {

	/**
	 * Cache key for language data
	 *
	 * @var string
	 */
	const CACHE_KEY = 'shopwr_lite_language_cache';

	/**
	 * Initialize the class.
	 *
	 * @since 1.0.0
	 */
	public function __construct() {
		// Language helper initialization.
	}

	/**
	 * Get available languages
	 *
	 * @since  1.0.0
	 * @return array Available languages.
	 */
	public static function get_available_languages() {
		return array(
			'en' => 'English',
			'nl' => 'Dutch',
			'de' => 'German',
			'fr' => 'French',
			'es' => 'Spanish',
			'it' => 'Italian',
			'pt' => 'Portuguese',
			'pl' => 'Polish',
			'tr' => 'Turkish',
			'ru' => 'Russian',
			'ar' => 'Arabic',
			'zh' => 'Chinese',
			'ja' => 'Japanese',
			'ko' => 'Korean',
		);
	}

	/**
	 * Get site language
	 *
	 * @since  1.0.0
	 * @return string Site language code.
	 */
	public static function get_site_language() {
		$locale = get_locale();
		$lang   = substr( $locale, 0, 2 );
		return strtolower( $lang );
	}

	/**
	 * Clear cache
	 *
	 * @since 1.0.0
	 */
	public static function clear_cache() {
		delete_transient( self::CACHE_KEY );
	}
}
