<?php
/**
 * Update Logs page for ShopWriter Lite
 *
 * @since      1.0.0
 * @package    ShopWriter_Lite
 */

// If this file is called directly, abort.
if ( ! defined( 'ABSPATH' ) ) {
	exit;
}
?>

<div class="wrap shopwr-lite-update-logs">
	<h1><?php esc_html_e( 'Content Update Logs', 'shopwriter-lite' ); ?></h1>

	<p class="description">
		<?php esc_html_e( 'View the history of all content updates made by ShopWriter Lite. You can revert any changes to restore the original content.', 'shopwriter-lite' ); ?>
	</p>

	<div class="shopwr-lite-logs-actions">
		<button type="button" class="button" id="refresh-logs">
			<span class="dashicons dashicons-update"></span>
			<?php esc_html_e( 'Refresh', 'shopwriter-lite' ); ?>
		</button>
		<button type="button" class="button" id="clear-all-logs" style="color: #a00;">
			<span class="dashicons dashicons-trash"></span>
			<?php esc_html_e( 'Clear All Logs', 'shopwriter-lite' ); ?>
		</button>
	</div>

	<div class="shopwr-lite-logs-container">
		<table class="wp-list-table widefat fixed striped" id="logs-table">
			<thead>
			<tr>
				<th scope="col" class="column-product"><?php esc_html_e( 'Product', 'shopwriter-lite' ); ?></th>
				<th scope="col" class="column-fields"><?php esc_html_e( 'Fields Updated', 'shopwriter-lite' ); ?></th>
				<th scope="col" class="column-user"><?php esc_html_e( 'User', 'shopwriter-lite' ); ?></th>
				<th scope="col" class="column-date"><?php esc_html_e( 'Date', 'shopwriter-lite' ); ?></th>
				<th scope="col" class="column-actions"><?php esc_html_e( 'Actions', 'shopwriter-lite' ); ?></th>
			</tr>
			</thead>
			<tbody id="logs-body">
			<tr class="no-items">
				<td colspan="5"><?php esc_html_e( 'Loading logs...', 'shopwriter-lite' ); ?></td>
			</tr>
			</tbody>
		</table>

		<div class="shopwr-lite-logs-pagination" id="logs-pagination"></div>
	</div>

	<!-- Log Details Side Panel -->
	<div class="shopwr-lite-side-panel-overlay" id="log-panel-overlay"></div>
	<div class="shopwr-lite-side-panel" id="log-details-panel">
		<div class="shopwr-lite-side-panel-header">
			<h2><?php esc_html_e( 'Content Changes', 'shopwriter-lite' ); ?></h2>
			<button type="button" class="shopwr-lite-side-panel-close" id="close-panel">&times;</button>
		</div>
		<div class="shopwr-lite-side-panel-body" id="log-details-content">
		</div>
		<div class="shopwr-lite-side-panel-footer">
			<button type="button" class="button" id="close-panel-btn">
				<?php esc_html_e( 'Close', 'shopwriter-lite' ); ?>
			</button>
			<button type="button" class="button button-primary" id="panel-revert-btn">
				<?php esc_html_e( 'Revert Changes', 'shopwriter-lite' ); ?>
			</button>
		</div>
	</div>
</div>

<script type="text/html" id="tmpl-log-row">
	<tr data-log-id="{{ data.id }}">
		<td class="column-product">
			<strong><a href="{{ data.edit_link }}" target="_blank">{{ data.product_name }}</a></strong>
			<br>
			<small>ID: {{ data.product_id }}</small>
		</td>
		<td class="column-fields">
			<# _.each(data.fields_updated, function(field) { #>
			<span class="shopwr-lite-field-badge">{{ field }}</span>
			<# }); #>
		</td>
		<td class="column-user">{{ data.user_name }}</td>
		<td class="column-date">{{ data.date_formatted }}</td>
		<td class="column-actions">
			<button type="button" class="button button-small view-details" data-log-id="{{ data.id }}">
				<?php esc_html_e( 'Details', 'shopwriter-lite' ); ?>
			</button>
			<button type="button" class="button button-small revert-btn" data-log-id="{{ data.id }}">
				<?php esc_html_e( 'Revert', 'shopwriter-lite' ); ?>
			</button>
		</td>
	</tr>
</script>
