<?php
/**
 * Admin settings page for ShopWriter Lite
 *
 * @since      1.0.0
 * @package    ShopWriter_Lite
 */

// If this file is called directly, abort.
if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

$shopwr_lite_settings = $this->api->get_settings();
$shopwr_lite_seo      = new SHOPWR_Lite_SEO();

// Get available languages.
$shopwr_lite_languages = SHOPWR_Lite_Language_Helper::get_available_languages();
?>

<div class="wrap shopwr-lite-settings">
	<h1><?php esc_html_e( 'ShopWriter Lite Settings', 'shopwriter-lite' ); ?></h1>

	<?php settings_errors( 'shopwr_lite_settings' ); ?>

	<!-- Upgrade Banner -->
	<div class="shopwr-lite-upgrade-banner">
		<div class="upgrade-content">
			<h2><?php esc_html_e( 'Upgrade to ShopWriter Pro', 'shopwriter-lite' ); ?></h2>
			<p><?php esc_html_e( 'Unlock all features including Product Title Generation, FAQ Generation, Category Generator, 301 Redirects, Queue Processing, Internal Linking, and more!', 'shopwriter-lite' ); ?></p>
			<a href="https://shop-writer.com/pricing/?utm_source=plugin&utm_medium=settings&utm_campaign=lite" target="_blank" class="button button-primary button-hero">
				<?php esc_html_e( 'Upgrade Now', 'shopwriter-lite' ); ?>
			</a>
		</div>
	</div>

	<form method="post" action="">
		<?php wp_nonce_field( 'shopwr_lite_settings_nonce' ); ?>

		<!-- License Settings -->
		<div class="shopwr-lite-settings-section">
			<h2><?php esc_html_e( 'License Settings', 'shopwriter-lite' ); ?></h2>
			<table class="form-table">
				<tr>
					<th scope="row">
						<label for="api_key"><?php esc_html_e( 'License Key', 'shopwriter-lite' ); ?></label>
					</th>
					<td>
						<input type="text" id="api_key" name="api_key" value="<?php echo esc_attr( $shopwr_lite_settings['api_key'] ); ?>" class="regular-text">
						<p class="description">
							<?php
							printf(
								/* translators: %s: link to get license key */
								esc_html__( 'Enter your ShopWriter license key. %s', 'shopwriter-lite' ),
								'<a href="https://shop-writer.com/my-account/?utm_source=plugin&utm_medium=settings&utm_campaign=lite" target="_blank">' . esc_html__( 'Get your license key', 'shopwriter-lite' ) . '</a>'
							);
							?>
						</p>
					</td>
				</tr>
			</table>
		</div>

		<!-- AI Model Settings -->
		<div class="shopwr-lite-settings-section">
			<h2><?php esc_html_e( 'AI Model Settings', 'shopwriter-lite' ); ?></h2>
			<table class="form-table">
				<tr>
					<th scope="row">
						<label for="model"><?php esc_html_e( 'AI Model', 'shopwriter-lite' ); ?></label>
					</th>
					<td>
						<select id="model" name="model">
							<option value="gpt-3.5-turbo" <?php selected( $shopwr_lite_settings['model'], 'gpt-3.5-turbo' ); ?>><?php esc_html_e( 'GPT-3.5 Turbo (Faster, Lower Cost)', 'shopwriter-lite' ); ?></option>
							<option value="gpt-4" <?php selected( $shopwr_lite_settings['model'], 'gpt-4' ); ?>><?php esc_html_e( 'GPT-4 (Higher Quality, Higher Cost)', 'shopwriter-lite' ); ?></option>
						</select>
						<p class="description"><?php esc_html_e( 'Select the AI model to use for content generation.', 'shopwriter-lite' ); ?></p>
					</td>
				</tr>
				<tr>
					<th scope="row">
						<label for="tone"><?php esc_html_e( 'Content Tone', 'shopwriter-lite' ); ?></label>
					</th>
					<td>
						<select id="tone" name="tone">
							<option value="professional" <?php selected( $shopwr_lite_settings['tone'], 'professional' ); ?>><?php esc_html_e( 'Professional', 'shopwriter-lite' ); ?></option>
							<option value="casual" <?php selected( $shopwr_lite_settings['tone'], 'casual' ); ?>><?php esc_html_e( 'Casual', 'shopwriter-lite' ); ?></option>
							<option value="friendly" <?php selected( $shopwr_lite_settings['tone'], 'friendly' ); ?>><?php esc_html_e( 'Friendly', 'shopwriter-lite' ); ?></option>
							<option value="formal" <?php selected( $shopwr_lite_settings['tone'], 'formal' ); ?>><?php esc_html_e( 'Formal', 'shopwriter-lite' ); ?></option>
							<option value="persuasive" <?php selected( $shopwr_lite_settings['tone'], 'persuasive' ); ?>><?php esc_html_e( 'Persuasive', 'shopwriter-lite' ); ?></option>
						</select>
						<p class="description"><?php esc_html_e( 'Select the tone for generated content.', 'shopwriter-lite' ); ?></p>
					</td>
				</tr>
			</table>
		</div>

		<!-- Language Settings -->
		<div class="shopwr-lite-settings-section">
			<h2><?php esc_html_e( 'Language Settings', 'shopwriter-lite' ); ?></h2>
			<table class="form-table">
				<tr>
					<th scope="row">
						<label for="source_language"><?php esc_html_e( 'Source Language', 'shopwriter-lite' ); ?></label>
					</th>
					<td>
						<select id="source_language" name="source_language">
							<?php foreach ( $shopwr_lite_languages as $shopwr_lite_language_code => $shopwr_lite_language_name ) : ?>
								<option value="<?php echo esc_attr( $shopwr_lite_language_code ); ?>" <?php selected( $shopwr_lite_settings['source_language'], $shopwr_lite_language_code ); ?>><?php echo esc_html( $shopwr_lite_language_name ); ?></option>
							<?php endforeach; ?>
						</select>
						<p class="description"><?php esc_html_e( 'The language of your existing product content.', 'shopwriter-lite' ); ?></p>
					</td>
				</tr>
				<tr>
					<th scope="row">
						<label for="website_language"><?php esc_html_e( 'Target Language', 'shopwriter-lite' ); ?></label>
					</th>
					<td>
						<select id="website_language" name="website_language">
							<?php foreach ( $shopwr_lite_languages as $shopwr_lite_language_code => $shopwr_lite_language_name ) : ?>
								<option value="<?php echo esc_attr( $shopwr_lite_language_code ); ?>" <?php selected( $shopwr_lite_settings['website_language'], $shopwr_lite_language_code ); ?>><?php echo esc_html( $shopwr_lite_language_name ); ?></option>
							<?php endforeach; ?>
						</select>
						<p class="description"><?php esc_html_e( 'The language for generated content.', 'shopwriter-lite' ); ?></p>
					</td>
				</tr>
			</table>
		</div>

		<!-- SEO Plugin Detection -->
		<?php if ( $seo->has_seo_plugin() ) : ?>
		<div class="shopwr-lite-settings-section shopwr-lite-notice-info">
			<p>
				<strong><?php esc_html_e( 'SEO Plugin Detected:', 'shopwriter-lite' ); ?></strong>
				<?php echo esc_html( $seo->get_active_seo_plugin() ); ?>
			</p>
			<p><?php esc_html_e( 'Meta titles and descriptions will be saved to your SEO plugin fields.', 'shopwriter-lite' ); ?></p>
		</div>
		<?php endif; ?>

		<!-- PRO-Only Settings (Disabled) -->
		<div class="shopwr-lite-settings-section shopwr-lite-pro-section disabled">
			<h2>
				<?php esc_html_e( 'Target Length Settings', 'shopwriter-lite' ); ?>
				<span class="shopwr-lite-pro-badge-inline">
					<svg width="12" height="12" viewBox="0 0 24 24" fill="currentColor"><path d="M18 8h-1V6c0-2.76-2.24-5-5-5S7 3.24 7 6v2H6c-1.1 0-2 .9-2 2v10c0 1.1.9 2 2 2h12c1.1 0 2-.9 2-2V10c0-1.1-.9-2-2-2zm-6 9c-1.1 0-2-.9-2-2s.9-2 2-2 2 .9 2 2-.9 2-2 2zm3.1-9H8.9V6c0-1.71 1.39-3.1 3.1-3.1 1.71 0 3.1 1.39 3.1 3.1v2z"/></svg>
					PRO
				</span>
			</h2>
			<p class="description"><?php esc_html_e( 'Configure minimum and maximum lengths for generated content. Available in Pro version.', 'shopwriter-lite' ); ?></p>
			<table class="form-table">
				<tr>
					<th scope="row"><?php esc_html_e( 'Description Length', 'shopwriter-lite' ); ?></th>
					<td>
						<input type="number" disabled value="100" class="small-text"> -
						<input type="number" disabled value="300" class="small-text"> <?php esc_html_e( 'words', 'shopwriter-lite' ); ?>
					</td>
				</tr>
				<tr>
					<th scope="row"><?php esc_html_e( 'Short Description Length', 'shopwriter-lite' ); ?></th>
					<td>
						<input type="number" disabled value="20" class="small-text"> -
						<input type="number" disabled value="50" class="small-text"> <?php esc_html_e( 'words', 'shopwriter-lite' ); ?>
					</td>
				</tr>
			</table>
		</div>

		<div class="shopwr-lite-settings-section shopwr-lite-pro-section disabled">
			<h2>
				<?php esc_html_e( 'Content Structure Settings', 'shopwriter-lite' ); ?>
				<span class="shopwr-lite-pro-badge-inline">
					<svg width="12" height="12" viewBox="0 0 24 24" fill="currentColor"><path d="M18 8h-1V6c0-2.76-2.24-5-5-5S7 3.24 7 6v2H6c-1.1 0-2 .9-2 2v10c0 1.1.9 2 2 2h12c1.1 0 2-.9 2-2V10c0-1.1-.9-2-2-2zm-6 9c-1.1 0-2-.9-2-2s.9-2 2-2 2 .9 2 2-.9 2-2 2zm3.1-9H8.9V6c0-1.71 1.39-3.1 3.1-3.1 1.71 0 3.1 1.39 3.1 3.1v2z"/></svg>
					PRO
				</span>
			</h2>
			<p class="description"><?php esc_html_e( 'Configure heading structure and excluded words. Available in Pro version.', 'shopwriter-lite' ); ?></p>
			<table class="form-table">
				<tr>
					<th scope="row"><?php esc_html_e( 'H2 Headings', 'shopwriter-lite' ); ?></th>
					<td><input type="number" disabled value="2" class="small-text"></td>
				</tr>
				<tr>
					<th scope="row"><?php esc_html_e( 'H3 Headings', 'shopwriter-lite' ); ?></th>
					<td><input type="number" disabled value="3" class="small-text"></td>
				</tr>
			</table>
		</div>

		<div class="shopwr-lite-settings-section shopwr-lite-pro-section disabled">
			<h2>
				<?php esc_html_e( 'Permalink Generation Settings', 'shopwriter-lite' ); ?>
				<span class="shopwr-lite-pro-badge-inline">
					<svg width="12" height="12" viewBox="0 0 24 24" fill="currentColor"><path d="M18 8h-1V6c0-2.76-2.24-5-5-5S7 3.24 7 6v2H6c-1.1 0-2 .9-2 2v10c0 1.1.9 2 2 2h12c1.1 0 2-.9 2-2V10c0-1.1-.9-2-2-2zm-6 9c-1.1 0-2-.9-2-2s.9-2 2-2 2 .9 2 2-.9 2-2 2zm3.1-9H8.9V6c0-1.71 1.39-3.1 3.1-3.1 1.71 0 3.1 1.39 3.1 3.1v2z"/></svg>
					PRO
				</span>
			</h2>
			<p class="description"><?php esc_html_e( 'Generate SEO-friendly URLs and 301 redirects. Available in Pro version.', 'shopwriter-lite' ); ?></p>
			<table class="form-table">
				<tr>
					<th scope="row"><?php esc_html_e( 'Enable Permalink Generation', 'shopwriter-lite' ); ?></th>
					<td><input type="checkbox" disabled></td>
				</tr>
			</table>
		</div>

		<div class="shopwr-lite-settings-section shopwr-lite-pro-section disabled">
			<h2>
				<?php esc_html_e( 'Open Graph & Social Media Settings', 'shopwriter-lite' ); ?>
				<span class="shopwr-lite-pro-badge-inline">
					<svg width="12" height="12" viewBox="0 0 24 24" fill="currentColor"><path d="M18 8h-1V6c0-2.76-2.24-5-5-5S7 3.24 7 6v2H6c-1.1 0-2 .9-2 2v10c0 1.1.9 2 2 2h12c1.1 0 2-.9 2-2V10c0-1.1-.9-2-2-2zm-6 9c-1.1 0-2-.9-2-2s.9-2 2-2 2 .9 2 2-.9 2-2 2zm3.1-9H8.9V6c0-1.71 1.39-3.1 3.1-3.1 1.71 0 3.1 1.39 3.1 3.1v2z"/></svg>
					PRO
				</span>
			</h2>
			<p class="description"><?php esc_html_e( 'Generate Open Graph meta tags for social media sharing. Available in Pro version.', 'shopwriter-lite' ); ?></p>
			<table class="form-table">
				<tr>
					<th scope="row"><?php esc_html_e( 'Enable Open Graph', 'shopwriter-lite' ); ?></th>
					<td><input type="checkbox" disabled></td>
				</tr>
			</table>
		</div>

		<div class="shopwr-lite-settings-section shopwr-lite-pro-section disabled">
			<h2>
				<?php esc_html_e( 'Content Generation Settings', 'shopwriter-lite' ); ?>
				<span class="shopwr-lite-pro-badge-inline">
					<svg width="12" height="12" viewBox="0 0 24 24" fill="currentColor"><path d="M18 8h-1V6c0-2.76-2.24-5-5-5S7 3.24 7 6v2H6c-1.1 0-2 .9-2 2v10c0 1.1.9 2 2 2h12c1.1 0 2-.9 2-2V10c0-1.1-.9-2-2-2zm-6 9c-1.1 0-2-.9-2-2s.9-2 2-2 2 .9 2 2-.9 2-2 2zm3.1-9H8.9V6c0-1.71 1.39-3.1 3.1-3.1 1.71 0 3.1 1.39 3.1 3.1v2z"/></svg>
					PRO
				</span>
			</h2>
			<p class="description"><?php esc_html_e( 'Custom AI instructions and field-specific prompts. Available in Pro version.', 'shopwriter-lite' ); ?></p>
			<table class="form-table">
				<tr>
					<th scope="row"><?php esc_html_e( 'Custom AI Instructions', 'shopwriter-lite' ); ?></th>
					<td><textarea disabled rows="4" class="large-text" placeholder="<?php esc_attr_e( 'Available in Pro version...', 'shopwriter-lite' ); ?>"></textarea></td>
				</tr>
			</table>
		</div>

		<p class="submit">
			<input type="submit" name="shopwr_lite_save_settings" class="button button-primary" value="<?php esc_attr_e( 'Save Settings', 'shopwriter-lite' ); ?>">
		</p>
	</form>
</div>
