<?php
/**
 * Fired during plugin deactivation
 *
 * @since      1.0.0
 * @package    ShopWriter_Lite
 */

// If this file is called directly, abort.
if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

/**
 * Fired during plugin deactivation.
 *
 * This class defines all code necessary to run during the plugin's deactivation.
 *
 * @since 1.0.0
 */
class SHOPWR_Lite_Deactivator {

	/**
	 * Deactivate the plugin.
	 *
	 * Clean up transients and flush rewrite rules.
	 *
	 * @since 1.0.0
	 */
	public static function deactivate() {
		// Delete transients.
		delete_transient( 'shopwr_lite_activated' );

		// Flush rewrite rules.
		flush_rewrite_rules();
	}
}
