<?php
/**
 * Product Meta Box for ShopWriter Lite
 *
 * @since      1.0.0
 * @package    ShopWriter_Lite
 */

// If this file is called directly, abort.
if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

$shopwr_lite_settings    = $this->api->get_settings();
$shopwr_lite_has_api_key = ! empty( $shopwr_lite_settings['api_key'] );
?>

<div class="shopwr-lite-product-meta-box">
	<?php if ( ! $shopwr_lite_has_api_key ) : ?>
		<div class="shopwr-lite-notice shopwr-lite-notice-warning">
			<p>
				<?php
				printf(
					/* translators: %s: link to settings */
					esc_html__( 'Please add your API key in the %s to start generating content.', 'shopwriter-lite' ),
					'<a href="' . esc_url( admin_url( 'admin.php?page=shopwriter-lite-settings' ) ) . '">' . esc_html__( 'Settings', 'shopwriter-lite' ) . '</a>'
				);
				?>
			</p>
		</div>
	<?php endif; ?>

	<div class="shopwr-lite-fields-selection">
		<p class="description"><?php esc_html_e( 'Select fields to generate:', 'shopwriter-lite' ); ?></p>

		<div class="shopwr-lite-field-checkboxes">
			<!-- Lite Fields (Available) -->
			<label class="shopwr-lite-field-checkbox">
				<input type="checkbox" name="shopwr_fields[]" value="short_description" checked>
				<?php esc_html_e( 'Short Description', 'shopwriter-lite' ); ?>
			</label>

			<label class="shopwr-lite-field-checkbox">
				<input type="checkbox" name="shopwr_fields[]" value="description" checked>
				<?php esc_html_e( 'Product Description', 'shopwriter-lite' ); ?>
			</label>

			<label class="shopwr-lite-field-checkbox">
				<input type="checkbox" name="shopwr_fields[]" value="meta_title" checked>
				<?php esc_html_e( 'Meta Title', 'shopwriter-lite' ); ?>
			</label>

			<label class="shopwr-lite-field-checkbox">
				<input type="checkbox" name="shopwr_fields[]" value="meta_description" checked>
				<?php esc_html_e( 'Meta Description', 'shopwriter-lite' ); ?>
			</label>

			<label class="shopwr-lite-field-checkbox">
				<input type="checkbox" name="shopwr_fields[]" value="alt_text">
				<?php esc_html_e( 'Featured Image Alt Text', 'shopwriter-lite' ); ?>
			</label>

			<!-- PRO Fields (Disabled) -->
			<label class="shopwr-lite-field-checkbox shopwr-lite-field-pro disabled" title="<?php esc_attr_e( 'Available in Pro version', 'shopwriter-lite' ); ?>">
				<input type="checkbox" disabled>
				<?php esc_html_e( 'Product Title', 'shopwriter-lite' ); ?>
				<span class="shopwr-lite-pro-badge-small">PRO</span>
			</label>

			<label class="shopwr-lite-field-checkbox shopwr-lite-field-pro disabled" title="<?php esc_attr_e( 'Available in Pro version', 'shopwriter-lite' ); ?>">
				<input type="checkbox" disabled>
				<?php esc_html_e( 'FAQ Section', 'shopwriter-lite' ); ?>
				<span class="shopwr-lite-pro-badge-small">PRO</span>
			</label>
		</div>
	</div>

	<div class="shopwr-lite-operation-selection">
		<label>
			<input type="radio" name="shopwr_operation" value="generate" checked>
			<?php esc_html_e( 'Generate', 'shopwriter-lite' ); ?>
		</label>
		<label>
			<input type="radio" name="shopwr_operation" value="rewrite">
			<?php esc_html_e( 'Rewrite', 'shopwriter-lite' ); ?>
		</label>
	</div>

	<div class="shopwr-lite-actions">
		<button type="button" class="button button-primary shopwr-lite-generate-btn" id="shopwr-lite-generate" data-product-id="<?php echo esc_attr( $post->ID ); ?>" <?php echo ! $has_api_key ? 'disabled' : ''; ?>>
			<?php esc_html_e( 'Generate Content', 'shopwriter-lite' ); ?>
		</button>
		<span class="spinner"></span>
	</div>

	<!-- Preview Section -->
	<div class="shopwr-lite-preview" id="shopwr-lite-preview" style="display: none;">
		<h4><?php esc_html_e( 'Generated Content Preview', 'shopwriter-lite' ); ?></h4>
		<div class="shopwr-lite-preview-content"></div>
		<div class="shopwr-lite-preview-actions">
			<button type="button" class="button button-primary" id="shopwr-lite-apply">
				<?php esc_html_e( 'Apply Changes', 'shopwriter-lite' ); ?>
			</button>
			<button type="button" class="button" id="shopwr-lite-regenerate">
				<?php esc_html_e( 'Regenerate', 'shopwriter-lite' ); ?>
			</button>
			<button type="button" class="button" id="shopwr-lite-cancel">
				<?php esc_html_e( 'Cancel', 'shopwriter-lite' ); ?>
			</button>
		</div>
	</div>

	<!-- Message Section -->
	<div class="shopwr-lite-message" id="shopwr-lite-message" style="display: none;"></div>

	<!-- Upgrade Notice -->
	<div class="shopwr-lite-upgrade-notice">
		<a href="https://shop-writer.com/pricing/?utm_source=plugin&utm_medium=product&utm_campaign=lite" target="_blank">
			<?php esc_html_e( 'Upgrade to Pro for more features', 'shopwriter-lite' ); ?> &rarr;
		</a>
	</div>
</div>
